/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.grpc.grpclb;

import alluxio.shaded.client.com.google.common.base.Stopwatch;
import alluxio.shaded.client.io.grpc.Context;
import alluxio.shaded.client.io.grpc.Internal;
import alluxio.shaded.client.io.grpc.LoadBalancer;
import alluxio.shaded.client.io.grpc.LoadBalancerProvider;
import alluxio.shaded.client.io.grpc.NameResolver;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.grpclb.CachedSubchannelPool;
import alluxio.shaded.client.io.grpc.grpclb.GrpclbConfig;
import alluxio.shaded.client.io.grpc.grpclb.GrpclbLoadBalancer;
import alluxio.shaded.client.io.grpc.grpclb.GrpclbState;
import alluxio.shaded.client.io.grpc.internal.ExponentialBackoffPolicy;
import alluxio.shaded.client.io.grpc.internal.JsonUtil;
import alluxio.shaded.client.io.grpc.internal.ServiceConfigUtil;
import alluxio.shaded.client.io.grpc.internal.TimeProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Internal
public final class GrpclbLoadBalancerProvider
extends LoadBalancerProvider {
    private static final GrpclbState.Mode DEFAULT_MODE = GrpclbState.Mode.ROUND_ROBIN;

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "grpclb";
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new GrpclbLoadBalancer(helper, Context.ROOT, new CachedSubchannelPool(helper), TimeProvider.SYSTEM_TIME_PROVIDER, Stopwatch.createUnstarted(), new ExponentialBackoffPolicy.Provider());
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingConfigPolicy) {
        try {
            return this.parseLoadBalancingConfigPolicyInternal(rawLoadBalancingConfigPolicy);
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError(Status.fromThrowable(e).withDescription("Failed to parse GRPCLB config: " + rawLoadBalancingConfigPolicy));
        }
    }

    NameResolver.ConfigOrError parseLoadBalancingConfigPolicyInternal(Map<String, ?> rawLoadBalancingPolicyConfig) {
        if (rawLoadBalancingPolicyConfig == null) {
            return NameResolver.ConfigOrError.fromConfig(GrpclbConfig.create(DEFAULT_MODE));
        }
        String serviceName = JsonUtil.getString(rawLoadBalancingPolicyConfig, "serviceName");
        List<?> rawChildPolicies = JsonUtil.getList(rawLoadBalancingPolicyConfig, "childPolicy");
        Long initialFallbackTimeoutNs = JsonUtil.getStringAsDuration(rawLoadBalancingPolicyConfig, "initialFallbackTimeout");
        long timeoutMs = GrpclbState.FALLBACK_TIMEOUT_MS;
        if (initialFallbackTimeoutNs != null) {
            timeoutMs = initialFallbackTimeoutNs / 1000000L;
        }
        List<ServiceConfigUtil.LbConfig> childPolicies = null;
        if (rawChildPolicies != null) {
            childPolicies = ServiceConfigUtil.unwrapLoadBalancingConfigList(JsonUtil.checkObjectList(rawChildPolicies));
        }
        if (childPolicies == null || childPolicies.isEmpty()) {
            return NameResolver.ConfigOrError.fromConfig(GrpclbConfig.create(DEFAULT_MODE, serviceName, timeoutMs));
        }
        ArrayList<String> policiesTried = new ArrayList<String>();
        for (ServiceConfigUtil.LbConfig childPolicy : childPolicies) {
            String childPolicyName;
            switch (childPolicyName = childPolicy.getPolicyName()) {
                case "round_robin": {
                    return NameResolver.ConfigOrError.fromConfig(GrpclbConfig.create(GrpclbState.Mode.ROUND_ROBIN, serviceName, timeoutMs));
                }
                case "pick_first": {
                    return NameResolver.ConfigOrError.fromConfig(GrpclbConfig.create(GrpclbState.Mode.PICK_FIRST, serviceName, timeoutMs));
                }
            }
            policiesTried.add(childPolicyName);
        }
        return NameResolver.ConfigOrError.fromError(Status.UNAVAILABLE.withDescription("None of " + policiesTried + " specified child policies are available."));
    }
}

