/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.dns;

import alluxio.shaded.client.io.netty.handler.logging.ByteBufFormat;
import alluxio.shaded.client.io.vertx.codegen.annotations.DataObject;
import alluxio.shaded.client.io.vertx.core.dns.DnsClientOptionsConverter;
import alluxio.shaded.client.io.vertx.core.json.JsonObject;

@DataObject(generateConverter=true)
public class DnsClientOptions {
    public static final int DEFAULT_PORT = -1;
    public static final String DEFAULT_HOST = null;
    public static final long DEFAULT_QUERY_TIMEOUT = 5000L;
    public static final boolean DEFAULT_LOG_ENABLED = false;
    public static final ByteBufFormat DEFAULT_LOG_ACTIVITY_FORMAT = ByteBufFormat.SIMPLE;
    public static final boolean DEFAULT_RECURSION_DESIRED = true;
    private int port = -1;
    private String host = DEFAULT_HOST;
    private long queryTimeout = 5000L;
    private boolean logActivity = false;
    private ByteBufFormat activityLogFormat = DEFAULT_LOG_ACTIVITY_FORMAT;
    private boolean recursionDesired = true;

    public DnsClientOptions() {
    }

    public DnsClientOptions(JsonObject json) {
        DnsClientOptionsConverter.fromJson(json, this);
    }

    public DnsClientOptions(DnsClientOptions other) {
        this.port = other.port;
        this.host = other.host;
        this.queryTimeout = other.queryTimeout;
        this.logActivity = other.logActivity;
        this.activityLogFormat = other.activityLogFormat;
        this.recursionDesired = other.recursionDesired;
    }

    public int getPort() {
        return this.port;
    }

    public DnsClientOptions setPort(int port) {
        if (port < 1 && port != -1) {
            throw new IllegalArgumentException("DNS client port " + port + " must be > 0 or equal to DEFAULT_PORT");
        }
        this.port = port;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public DnsClientOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public long getQueryTimeout() {
        return this.queryTimeout;
    }

    public DnsClientOptions setQueryTimeout(long queryTimeout) {
        if (queryTimeout < 1L) {
            throw new IllegalArgumentException("queryTimeout must be > 0");
        }
        this.queryTimeout = queryTimeout;
        return this;
    }

    public boolean getLogActivity() {
        return this.logActivity;
    }

    public ByteBufFormat getActivityLogFormat() {
        return this.activityLogFormat;
    }

    public DnsClientOptions setLogActivity(boolean logActivity) {
        this.logActivity = logActivity;
        return this;
    }

    public DnsClientOptions setActivityLogFormat(ByteBufFormat activityLogFormat) {
        this.activityLogFormat = activityLogFormat;
        return this;
    }

    public boolean isRecursionDesired() {
        return this.recursionDesired;
    }

    public DnsClientOptions setRecursionDesired(boolean recursionDesired) {
        this.recursionDesired = recursionDesired;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        DnsClientOptionsConverter.toJson(this, json);
        return json;
    }
}

