/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.http.impl;

import alluxio.shaded.client.io.netty.channel.Channel;
import alluxio.shaded.client.io.netty.channel.ChannelHandler;
import alluxio.shaded.client.io.netty.channel.ChannelHandlerContext;
import alluxio.shaded.client.io.netty.channel.ChannelPipeline;
import alluxio.shaded.client.io.netty.handler.codec.http.HttpClientCodec;
import alluxio.shaded.client.io.netty.handler.codec.http.HttpContentDecompressor;
import alluxio.shaded.client.io.netty.handler.logging.LoggingHandler;
import alluxio.shaded.client.io.netty.handler.ssl.SslHandler;
import alluxio.shaded.client.io.netty.handler.timeout.IdleStateHandler;
import alluxio.shaded.client.io.vertx.core.AsyncResult;
import alluxio.shaded.client.io.vertx.core.Future;
import alluxio.shaded.client.io.vertx.core.Handler;
import alluxio.shaded.client.io.vertx.core.Promise;
import alluxio.shaded.client.io.vertx.core.http.HttpClientOptions;
import alluxio.shaded.client.io.vertx.core.http.HttpHeaders;
import alluxio.shaded.client.io.vertx.core.http.HttpVersion;
import alluxio.shaded.client.io.vertx.core.http.impl.Http1xClientConnection;
import alluxio.shaded.client.io.vertx.core.http.impl.Http2ClientConnection;
import alluxio.shaded.client.io.vertx.core.http.impl.Http2UpgradeClientConnection;
import alluxio.shaded.client.io.vertx.core.http.impl.HttpClientConnection;
import alluxio.shaded.client.io.vertx.core.http.impl.HttpClientImpl;
import alluxio.shaded.client.io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import alluxio.shaded.client.io.vertx.core.impl.ContextInternal;
import alluxio.shaded.client.io.vertx.core.impl.EventLoopContext;
import alluxio.shaded.client.io.vertx.core.impl.future.PromiseInternal;
import alluxio.shaded.client.io.vertx.core.net.NetSocket;
import alluxio.shaded.client.io.vertx.core.net.ProxyOptions;
import alluxio.shaded.client.io.vertx.core.net.SocketAddress;
import alluxio.shaded.client.io.vertx.core.net.impl.NetClientImpl;
import alluxio.shaded.client.io.vertx.core.net.impl.NetSocketImpl;
import alluxio.shaded.client.io.vertx.core.net.impl.VertxHandler;
import alluxio.shaded.client.io.vertx.core.spi.metrics.ClientMetrics;
import alluxio.shaded.client.io.vertx.core.spi.metrics.HttpClientMetrics;
import java.util.ArrayList;
import java.util.Map;

public class HttpChannelConnector {
    private final HttpClientImpl client;
    private final NetClientImpl netClient;
    private final HttpClientOptions options;
    private final ProxyOptions proxyOptions;
    private final ClientMetrics metrics;
    private final boolean ssl;
    private final boolean useAlpn;
    private final HttpVersion version;
    private final SocketAddress peerAddress;
    private final SocketAddress server;

    public HttpChannelConnector(HttpClientImpl client, NetClientImpl netClient, ProxyOptions proxyOptions, ClientMetrics metrics, HttpVersion version, boolean ssl, boolean useAlpn, SocketAddress peerAddress, SocketAddress server) {
        this.client = client;
        this.netClient = netClient;
        this.metrics = metrics;
        this.options = client.options();
        this.proxyOptions = proxyOptions;
        this.ssl = ssl;
        this.useAlpn = useAlpn;
        this.version = version;
        this.peerAddress = peerAddress;
        this.server = server;
    }

    public SocketAddress server() {
        return this.server;
    }

    private void connect(EventLoopContext context, Promise<NetSocket> promise) {
        this.netClient.connectInternal(this.proxyOptions, this.server, this.peerAddress, this.options.isForceSni() ? this.peerAddress.host() : null, this.ssl, this.useAlpn, false, promise, context, 0);
    }

    public Future<HttpClientConnection> wrap(EventLoopContext context, NetSocket so_) {
        NetSocketImpl so = (NetSocketImpl)so_;
        Object metric = so.metric();
        PromiseInternal<HttpClientConnection> promise = context.promise();
        ChannelPipeline pipeline = so.channelHandlerContext().pipeline();
        ArrayList<ChannelHandler> removedHandlers = new ArrayList<ChannelHandler>();
        for (Map.Entry stringChannelHandlerEntry : pipeline) {
            ChannelHandler handler = (ChannelHandler)stringChannelHandlerEntry.getValue();
            if (handler instanceof SslHandler) continue;
            removedHandlers.add(handler);
        }
        removedHandlers.forEach(pipeline::remove);
        Channel ch = so.channelHandlerContext().channel();
        if (this.ssl) {
            String protocol = so.applicationLayerProtocol();
            if (this.useAlpn) {
                if ("h2".equals(protocol)) {
                    this.applyHttp2ConnectionOptions(ch.pipeline());
                    this.http2Connected(context, metric, ch, promise);
                } else {
                    this.applyHttp1xConnectionOptions(ch.pipeline());
                    HttpVersion fallbackProtocol = "http/1.0".equals(protocol) ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1;
                    this.http1xConnected(fallbackProtocol, this.server, true, context, metric, ch, promise);
                }
            } else {
                this.applyHttp1xConnectionOptions(ch.pipeline());
                this.http1xConnected(this.version, this.server, true, context, metric, ch, promise);
            }
        } else if (this.version == HttpVersion.HTTP_2) {
            if (this.options.isHttp2ClearTextUpgrade()) {
                this.applyHttp1xConnectionOptions(pipeline);
                this.http1xConnected(this.version, this.server, false, context, metric, ch, promise);
            } else {
                this.applyHttp2ConnectionOptions(pipeline);
                this.http2Connected(context, metric, ch, promise);
            }
        } else {
            this.applyHttp1xConnectionOptions(pipeline);
            this.http1xConnected(this.version, this.server, false, context, metric, ch, promise);
        }
        return promise.future();
    }

    public void httpConnect(EventLoopContext context, Handler<AsyncResult<HttpClientConnection>> handler) {
        PromiseInternal<NetSocket> promise = context.promise();
        Future fut = promise.future().flatMap(so -> this.wrap(context, (NetSocket)so));
        fut.onComplete(handler);
        this.connect(context, promise);
    }

    private void applyHttp2ConnectionOptions(ChannelPipeline pipeline) {
        int idleTimeout = this.options.getIdleTimeout();
        int readIdleTimeout = this.options.getReadIdleTimeout();
        int writeIdleTimeout = this.options.getWriteIdleTimeout();
        if (idleTimeout > 0 || readIdleTimeout > 0 || writeIdleTimeout > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(readIdleTimeout, writeIdleTimeout, idleTimeout, this.options.getIdleTimeoutUnit()));
        }
    }

    private void applyHttp1xConnectionOptions(ChannelPipeline pipeline) {
        int idleTimeout = this.options.getIdleTimeout();
        int readIdleTimeout = this.options.getReadIdleTimeout();
        int writeIdleTimeout = this.options.getWriteIdleTimeout();
        if (idleTimeout > 0 || readIdleTimeout > 0 || writeIdleTimeout > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(readIdleTimeout, writeIdleTimeout, idleTimeout, this.options.getIdleTimeoutUnit()));
        }
        if (this.options.getLogActivity()) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler(this.options.getActivityLogDataFormat()));
        }
        pipeline.addLast("codec", (ChannelHandler)new HttpClientCodec(this.options.getMaxInitialLineLength(), this.options.getMaxHeaderSize(), this.options.getMaxChunkSize(), false, !HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION, this.options.getDecoderInitialBufferSize()));
        if (this.options.isTryUseCompression()) {
            pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor(false));
        }
    }

    private void http1xConnected(HttpVersion version, SocketAddress server, boolean ssl, ContextInternal context, Object socketMetric, Channel ch, Promise<HttpClientConnection> future) {
        boolean upgrade = version == HttpVersion.HTTP_2 && this.options.isHttp2ClearTextUpgrade();
        VertxHandler<Http1xClientConnection> clientHandler = VertxHandler.create(chctx -> {
            HttpClientMetrics met = this.client.metrics();
            Http1xClientConnection conn = new Http1xClientConnection(upgrade ? HttpVersion.HTTP_1_1 : version, this.client, (ChannelHandlerContext)chctx, ssl, server, context, this.metrics);
            if (met != null) {
                conn.metric(socketMetric);
                met.endpointConnected(this.metrics);
            }
            return conn;
        });
        clientHandler.addHandler(conn -> {
            if (upgrade) {
                future.complete(new Http2UpgradeClientConnection(this.client, (Http1xClientConnection)conn));
            } else {
                future.complete((HttpClientConnection)conn);
            }
        });
        ch.pipeline().addLast("handler", clientHandler);
    }

    private void http2Connected(EventLoopContext context, Object metric, Channel ch, PromiseInternal<HttpClientConnection> promise) {
        VertxHttp2ConnectionHandler<Http2ClientConnection> clientHandler;
        try {
            clientHandler = Http2ClientConnection.createHttp2ConnectionHandler(this.client, this.metrics, context, false, metric);
            ch.pipeline().addLast("handler", clientHandler);
            ch.flush();
        }
        catch (Exception e) {
            this.connectFailed(ch, e, promise);
            return;
        }
        clientHandler.connectFuture().addListener(promise);
    }

    private void connectFailed(Channel ch, Throwable t, Promise<HttpClientConnection> future) {
        if (ch != null) {
            try {
                ch.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        future.tryFail(t);
    }
}

