/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.apache.commons.compress.harmony.unpack200.bytecode;

import alluxio.shaded.client.org.apache.commons.compress.harmony.pack200.Pack200Exception;
import alluxio.shaded.client.org.apache.commons.compress.harmony.unpack200.bytecode.Attribute;
import alluxio.shaded.client.org.apache.commons.compress.harmony.unpack200.bytecode.CPUTF8;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

public abstract class BCIRenumberedAttribute
extends Attribute {
    protected boolean renumbered;

    @Override
    public boolean hasBCIRenumbering() {
        return true;
    }

    public BCIRenumberedAttribute(CPUTF8 attributeName) {
        super(attributeName);
    }

    @Override
    protected abstract int getLength();

    @Override
    protected abstract void writeBody(DataOutputStream var1) throws IOException;

    @Override
    public abstract String toString();

    protected abstract int[] getStartPCs();

    public void renumber(List byteCodeOffsets) throws Pack200Exception {
        if (this.renumbered) {
            throw new Error("Trying to renumber a line number table that has already been renumbered");
        }
        this.renumbered = true;
        int[] startPCs = this.getStartPCs();
        for (int index = 0; index < startPCs.length; ++index) {
            startPCs[index] = (Integer)byteCodeOffsets.get(startPCs[index]);
        }
    }
}

