/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.software.amazon.ionimpl;

import alluxio.shaded.client.software.amazon.ionIonBlob;
import alluxio.shaded.client.software.amazon.ionIonBool;
import alluxio.shaded.client.software.amazon.ionIonCatalog;
import alluxio.shaded.client.software.amazon.ionIonClob;
import alluxio.shaded.client.software.amazon.ionIonContainer;
import alluxio.shaded.client.software.amazon.ionIonDatagram;
import alluxio.shaded.client.software.amazon.ionIonDecimal;
import alluxio.shaded.client.software.amazon.ionIonException;
import alluxio.shaded.client.software.amazon.ionIonFloat;
import alluxio.shaded.client.software.amazon.ionIonInt;
import alluxio.shaded.client.software.amazon.ionIonSequence;
import alluxio.shaded.client.software.amazon.ionIonString;
import alluxio.shaded.client.software.amazon.ionIonStruct;
import alluxio.shaded.client.software.amazon.ionIonSymbol;
import alluxio.shaded.client.software.amazon.ionIonTimestamp;
import alluxio.shaded.client.software.amazon.ionIonType;
import alluxio.shaded.client.software.amazon.ionIonValue;
import alluxio.shaded.client.software.amazon.ionSymbolTable;
import alluxio.shaded.client.software.amazon.ionSymbolToken;
import alluxio.shaded.client.software.amazon.ionTimestamp;
import alluxio.shaded.client.software.amazon.ionValueFactory;
import alluxio.shaded.client.software.amazon.ionimpl.IonWriterSystem;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateIonDatagram;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateIonValue;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateUtils;
import alluxio.shaded.client.software.amazon.ionimpl.SymbolTokenImpl;
import alluxio.shaded.client.software.amazon.ionsystem.IonWriterBuilder;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

final class IonWriterSystemTree
extends IonWriterSystem {
    private final ionValueFactory _factory;
    private final ionIonCatalog _catalog;
    private final int _initialDepth;
    private boolean _in_struct;
    private ionIonContainer _current_parent;
    private int _parent_stack_top = 0;
    private ionIonContainer[] _parent_stack = new ionIonContainer[10];

    protected IonWriterSystemTree(ionSymbolTable defaultSystemSymbolTable, ionIonCatalog catalog, ionIonContainer rootContainer, IonWriterBuilder.InitialIvmHandling initialIvmHandling) {
        super(defaultSystemSymbolTable, initialIvmHandling, IonWriterBuilder.IvmMinimizing.ADJACENT);
        if (rootContainer == null) {
            throw new NullPointerException();
        }
        this._factory = rootContainer.getSystem();
        this._catalog = catalog;
        this._current_parent = rootContainer;
        this._in_struct = this._current_parent instanceof ionIonStruct;
        int depth = 0;
        if (!(rootContainer instanceof ionIonDatagram)) {
            ionIonContainer c = rootContainer;
            do {
                ++depth;
            } while ((c = c.getContainer()) != null);
        }
        this._initialDepth = depth;
    }

    public int getDepth() {
        return this._parent_stack_top + this._initialDepth;
    }

    protected ionIonType getContainer() {
        ionIonType containerType = this._parent_stack_top > 0 ? this._parent_stack[this._parent_stack_top - 1].getType() : ionIonType.DATAGRAM;
        return containerType;
    }

    public boolean isInStruct() {
        return this._in_struct;
    }

    protected ionIonValue get_root() {
        ionIonContainer container = this._parent_stack_top > 0 ? this._parent_stack[0] : this._current_parent;
        return container;
    }

    private void pushParent(ionIonContainer newParent) {
        int oldlen = this._parent_stack.length;
        if (this._parent_stack_top >= oldlen) {
            int newlen = oldlen * 2;
            ionIonContainer[] temp = new ionIonContainer[newlen];
            System.arraycopy(this._parent_stack, 0, temp, 0, oldlen);
            this._parent_stack = temp;
        }
        this._parent_stack[this._parent_stack_top++] = this._current_parent;
        this._current_parent = newParent;
        this._in_struct = this._current_parent instanceof ionIonStruct;
    }

    private void popParent() {
        if (this._parent_stack_top < 1) {
            throw new IllegalStateException("Cannot stepOut any further, already at top level.");
        }
        --this._parent_stack_top;
        this._current_parent = this._parent_stack[this._parent_stack_top];
        this._in_struct = this._current_parent instanceof ionIonStruct;
    }

    private void append(ionIonValue value) {
        try {
            super.startValue();
        }
        catch (IOException e) {
            throw new ionIonException(e);
        }
        if (this.hasAnnotations()) {
            ionSymbolToken[] annotations = this.getTypeAnnotationSymbols();
            ((PrivateIonValue)value).setTypeAnnotationSymbols(annotations);
            this.clearAnnotations();
        }
        if (this._in_struct) {
            ionSymbolToken sym = this.assumeFieldNameSymbol();
            ionIonStruct struct = (ionIonStruct)this._current_parent;
            struct.add(sym, value);
            this.clearFieldName();
        } else {
            ((ionIonSequence)this._current_parent).add(value);
        }
    }

    public void stepIn(ionIonType containerType) throws IOException {
        ionIonContainer v;
        switch (containerType) {
            case LIST: {
                v = this._factory.newEmptyList();
                break;
            }
            case SEXP: {
                v = this._factory.newEmptySexp();
                break;
            }
            case STRUCT: {
                v = this._factory.newEmptyStruct();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.append(v);
        this.pushParent(v);
    }

    public void stepOut() throws IOException {
        ionIonContainer prior = this._current_parent;
        this.popParent();
        if (this._current_parent instanceof ionIonDatagram && PrivateUtils.valueIsLocalSymbolTable(prior)) {
            ionSymbolTable symbol_table = PrivateUtils.newLocalSymtab(this._default_system_symbol_table, this._catalog, (ionIonStruct)prior);
            this.setSymbolTable(symbol_table);
        }
    }

    void writeIonVersionMarkerAsIs(ionSymbolTable systemSymtab) throws IOException {
        this.startValue();
        ionIonValue root = this.get_root();
        ((PrivateIonDatagram)root).appendTrailingSymbolTable(systemSymtab);
        this.endValue();
    }

    void writeLocalSymtab(ionSymbolTable symtab) throws IOException {
        ionIonValue root = this.get_root();
        ((PrivateIonDatagram)root).appendTrailingSymbolTable(symtab);
        super.writeLocalSymtab(symtab);
    }

    final ionSymbolTable inject_local_symbol_table() throws IOException {
        return PrivateUtils.newLocalSymtab(this._factory, this.getSymbolTable(), new ionSymbolTable[0]);
    }

    public void writeNull(ionIonType type) throws IOException {
        ionIonValue v = this._factory.newNull(type);
        this.append(v);
    }

    public void writeBool(boolean value) throws IOException {
        ionIonBool v = this._factory.newBool(value);
        this.append(v);
    }

    public void writeInt(int value) throws IOException {
        ionIonInt v = this._factory.newInt(value);
        this.append(v);
    }

    public void writeInt(long value) throws IOException {
        ionIonInt v = this._factory.newInt(value);
        this.append(v);
    }

    public void writeInt(BigInteger value) throws IOException {
        ionIonInt v = this._factory.newInt(value);
        this.append(v);
    }

    public void writeFloat(double value) throws IOException {
        ionIonFloat v = this._factory.newNullFloat();
        v.setValue(value);
        this.append(v);
    }

    public void writeDecimal(BigDecimal value) throws IOException {
        ionIonDecimal v = this._factory.newNullDecimal();
        v.setValue(value);
        this.append(v);
    }

    public void writeTimestamp(ionTimestamp value) throws IOException {
        ionIonTimestamp v = this._factory.newTimestamp(value);
        this.append(v);
    }

    public void writeString(String value) throws IOException {
        ionIonString v = this._factory.newString(value);
        this.append(v);
    }

    void writeSymbolAsIs(int symbolId) {
        String name = this.getSymbolTable().findKnownSymbol(symbolId);
        SymbolTokenImpl is = new SymbolTokenImpl(name, symbolId);
        ionIonSymbol v = this._factory.newSymbol(is);
        this.append(v);
    }

    public void writeSymbolAsIs(String value) {
        ionIonSymbol v = this._factory.newSymbol(value);
        this.append(v);
    }

    public void writeClob(byte[] value, int start, int len) throws IOException {
        ionIonClob v = this._factory.newClob(value, start, len);
        this.append(v);
    }

    public void writeBlob(byte[] value, int start, int len) throws IOException {
        ionIonBlob v = this._factory.newBlob(value, start, len);
        this.append(v);
    }

    public void flush() {
    }

    public void close() {
    }
}

