/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.Client;
import alluxio.client.block.RetryHandlingBlockMasterClient;
import alluxio.client.block.options.GetWorkerReportOptions;
import alluxio.grpc.DecommissionWorkerPOptions;
import alluxio.grpc.RemoveDisabledWorkerPOptions;
import alluxio.grpc.WorkerLostStorageInfo;
import alluxio.master.MasterClientContext;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.BlockInfo;
import alluxio.wire.BlockMasterInfo;
import alluxio.wire.WorkerInfo;
import java.io.IOException;
import java.util.List;
import java.util.Set;

@ThreadSafe
public interface BlockMasterClient
extends Client {
    public List<WorkerInfo> getWorkerInfoList() throws IOException;

    public List<WorkerInfo> getLostWorkerInfoList() throws IOException;

    public void removeDisabledWorker(RemoveDisabledWorkerPOptions var1) throws IOException;

    public List<WorkerInfo> getWorkerReport(GetWorkerReportOptions var1) throws IOException;

    public List<WorkerLostStorageInfo> getWorkerLostStorage() throws IOException;

    public BlockInfo getBlockInfo(long var1) throws IOException;

    public BlockMasterInfo getBlockMasterInfo(Set<BlockMasterInfo.BlockMasterInfoField> var1) throws IOException;

    public long getCapacityBytes() throws IOException;

    public long getUsedBytes() throws IOException;

    public void decommissionWorker(DecommissionWorkerPOptions var1) throws IOException;

    public static class Factory {
        private Factory() {
        }

        public static BlockMasterClient create(MasterClientContext conf) {
            return new RetryHandlingBlockMasterClient(conf);
        }
    }
}

