/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.CacheUsage;
import alluxio.client.file.cache.CacheUsageView;
import alluxio.client.file.cache.DefaultPageMetaStore;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.client.file.cache.evictor.CacheEvictor;
import alluxio.client.file.cache.evictor.CacheEvictorOptions;
import alluxio.client.file.cache.store.PageStoreDir;
import alluxio.client.quota.CacheScope;
import alluxio.exception.PageNotFoundException;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.GuardedBy;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

@NotThreadSafe
public class QuotaPageMetaStore
extends DefaultPageMetaStore {
    private final Map<CacheScope, Long> mBytesInScope = new ConcurrentHashMap<CacheScope, Long>();
    private final Map<CacheScope, CacheEvictor> mCacheEvictors = new ConcurrentHashMap<CacheScope, CacheEvictor>();
    private final Supplier<CacheEvictor> mSupplier = () -> CacheEvictor.create(cacheEvictorOptions);

    public QuotaPageMetaStore(CacheEvictorOptions cacheEvictorOptions, List<PageStoreDir> dirs) {
        super(dirs);
    }

    @Override
    @GuardedBy(value="getLock()")
    public void addPage(PageId pageId, PageInfo pageInfo) {
        super.addPage(pageId, pageInfo);
        for (CacheScope cacheScope = pageInfo.getScope(); cacheScope != CacheScope.GLOBAL; cacheScope = cacheScope.parent()) {
            this.mBytesInScope.compute(cacheScope, (k, v) -> v == null ? pageInfo.getPageSize() : v + pageInfo.getPageSize());
            CacheEvictor evictor = this.mCacheEvictors.computeIfAbsent(cacheScope, k -> this.mSupplier.get());
            evictor.updateOnPut(pageId);
        }
    }

    @Override
    @GuardedBy(value="getLock()")
    public PageInfo getPageInfo(PageId pageId) throws PageNotFoundException {
        PageInfo pageInfo = super.getPageInfo(pageId);
        for (CacheScope cacheScope = pageInfo.getScope(); cacheScope != CacheScope.GLOBAL; cacheScope = cacheScope.parent()) {
            CacheEvictor evictor = this.mCacheEvictors.computeIfAbsent(cacheScope, k -> this.mSupplier.get());
            evictor.updateOnPut(pageId);
        }
        return pageInfo;
    }

    @Override
    @GuardedBy(value="getLock()")
    public PageInfo removePage(PageId pageId) throws PageNotFoundException {
        PageInfo pageInfo = super.removePage(pageId);
        for (CacheScope cacheScope = pageInfo.getScope(); cacheScope != CacheScope.GLOBAL; cacheScope = cacheScope.parent()) {
            this.mBytesInScope.computeIfPresent(cacheScope, (k, v) -> v - pageInfo.getPageSize());
            CacheEvictor evictor = this.mCacheEvictors.computeIfAbsent(cacheScope, k -> this.mSupplier.get());
            evictor.updateOnDelete(pageId);
        }
        return pageInfo;
    }

    public long bytes(CacheScope cacheScope) {
        if (cacheScope == CacheScope.GLOBAL) {
            return this.bytes();
        }
        return this.mBytesInScope.computeIfAbsent(cacheScope, k -> 0L);
    }

    @Override
    @GuardedBy(value="getLock()")
    public void reset() {
        super.reset();
        for (CacheEvictor evictor : this.mCacheEvictors.values()) {
            evictor.reset();
        }
        this.mBytesInScope.clear();
    }

    @Override
    @Nullable
    @GuardedBy(value="getLock()")
    public PageInfo evict(CacheScope cacheScope, PageStoreDir pageStoreDir) {
        if (cacheScope == CacheScope.GLOBAL) {
            return this.evictInternal(pageStoreDir.getEvictor());
        }
        CacheEvictor evictor = this.mCacheEvictors.computeIfAbsent(cacheScope, k -> this.mSupplier.get());
        return this.evictInternal(evictor);
    }

    @Override
    public Optional<CacheUsage> getUsage() {
        return Optional.of(new Usage());
    }

    class Usage
    extends DefaultPageMetaStore.Usage {
        Usage() {
        }

        @Override
        public Optional<CacheUsage> partitionedBy(CacheUsage.PartitionDescriptor<?> partition) {
            if (partition instanceof CacheUsage.ScopePartition) {
                CacheScope scope = ((CacheUsage.ScopePartition)partition).getIdentifier();
                long capacity = this.capacity();
                long used = QuotaPageMetaStore.this.bytes(scope);
                long available = capacity - QuotaPageMetaStore.this.bytes();
                return Optional.of(new CacheUsageView.ImmutableCacheUsageView(used, available, capacity));
            }
            return super.partitionedBy(partition);
        }
    }
}

