/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.cuckoofilter;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.client.quota.CacheScope;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentHashMap;

public class ScopeEncoder {
    private final int mMaxNumScopes;
    private final int mScopeMask;
    private final ConcurrentHashMap<CacheScope, Integer> mScopeToId;
    private int mNextId;

    public ScopeEncoder(int bitsPerScope) {
        Preconditions.checkArgument(bitsPerScope > 0 && bitsPerScope < 31, "check the value of bitsPerScope");
        this.mMaxNumScopes = 1 << bitsPerScope;
        this.mScopeMask = this.mMaxNumScopes - 1;
        this.mNextId = 0;
        this.mScopeToId = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_OF_PUTIFABSENT_IGNORED"})
    public int encode(CacheScope scopeInfo) {
        if (!this.mScopeToId.containsKey(scopeInfo)) {
            ScopeEncoder scopeEncoder = this;
            synchronized (scopeEncoder) {
                if (!this.mScopeToId.containsKey(scopeInfo)) {
                    int id = this.mNextId;
                    Preconditions.checkArgument(id < this.mMaxNumScopes, "too many scopes in shadow cache");
                    ++this.mNextId;
                    this.mScopeToId.putIfAbsent(scopeInfo, id);
                }
            }
        }
        return this.mScopeToId.get(scopeInfo) & this.mScopeMask;
    }
}

