/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.etcd.jetcd.api;

import alluxio.shaded.client.io.etcd.jetcd.api.ClusterGrpc;
import alluxio.shaded.client.io.etcd.jetcd.api.MemberAddRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.MemberAddResponse;
import alluxio.shaded.client.io.etcd.jetcd.api.MemberListRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.MemberListResponse;
import alluxio.shaded.client.io.etcd.jetcd.api.MemberRemoveRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.MemberRemoveResponse;
import alluxio.shaded.client.io.etcd.jetcd.api.MemberUpdateRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.MemberUpdateResponse;
import alluxio.shaded.client.io.grpc.BindableService;
import alluxio.shaded.client.io.grpc.CallOptions;
import alluxio.shaded.client.io.grpc.Channel;
import alluxio.shaded.client.io.grpc.ServerServiceDefinition;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.StatusRuntimeException;
import alluxio.shaded.client.io.grpc.stub.AbstractStub;
import alluxio.shaded.client.io.grpc.stub.ServerCalls;
import alluxio.shaded.client.io.grpc.stub.StreamObserver;
import alluxio.shaded.client.io.vertx.core.Future;
import alluxio.shaded.client.io.vertx.core.Vertx;
import alluxio.shaded.client.io.vertx.core.impl.ContextInternal;
import alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls;

public final class VertxClusterGrpc {
    private static final int METHODID_MEMBER_ADD = 0;
    private static final int METHODID_MEMBER_REMOVE = 1;
    private static final int METHODID_MEMBER_UPDATE = 2;
    private static final int METHODID_MEMBER_LIST = 3;

    private VertxClusterGrpc() {
    }

    public static ClusterVertxStub newVertxStub(Channel channel) {
        return new ClusterVertxStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final ClusterVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(ClusterVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        @Override
        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne((MemberAddRequest)request, responseObserver, this.compression, this.serviceImpl::memberAdd);
                    break;
                }
                case 1: {
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne((MemberRemoveRequest)request, responseObserver, this.compression, this.serviceImpl::memberRemove);
                    break;
                }
                case 2: {
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne((MemberUpdateRequest)request, responseObserver, this.compression, this.serviceImpl::memberUpdate);
                    break;
                }
                case 3: {
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne((MemberListRequest)request, responseObserver, this.compression, this.serviceImpl::memberList);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        @Override
        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static abstract class ClusterVertxImplBase
    implements BindableService {
        private String compression;

        public ClusterVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public Future<MemberAddResponse> memberAdd(MemberAddRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Future<MemberRemoveResponse> memberRemove(MemberRemoveRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Future<MemberUpdateResponse> memberUpdate(MemberUpdateRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Future<MemberListResponse> memberList(MemberListRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        @Override
        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder(ClusterGrpc.getServiceDescriptor()).addMethod(ClusterGrpc.getMemberAddMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0, this.compression))).addMethod(ClusterGrpc.getMemberRemoveMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1, this.compression))).addMethod(ClusterGrpc.getMemberUpdateMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2, this.compression))).addMethod(ClusterGrpc.getMemberListMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 3, this.compression))).build();
        }
    }

    public static final class ClusterVertxStub
    extends AbstractStub<ClusterVertxStub> {
        private final ContextInternal ctx;
        private ClusterGrpc.ClusterStub delegateStub;

        private ClusterVertxStub(Channel channel) {
            super(channel);
            this.delegateStub = ClusterGrpc.newStub(channel);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        private ClusterVertxStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = ClusterGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        @Override
        protected ClusterVertxStub build(Channel channel, CallOptions callOptions) {
            return new ClusterVertxStub(channel, callOptions);
        }

        public Future<MemberAddResponse> memberAdd(MemberAddRequest request) {
            return ClientCalls.oneToOne(this.ctx, request, this.delegateStub::memberAdd);
        }

        public Future<MemberRemoveResponse> memberRemove(MemberRemoveRequest request) {
            return ClientCalls.oneToOne(this.ctx, request, this.delegateStub::memberRemove);
        }

        public Future<MemberUpdateResponse> memberUpdate(MemberUpdateRequest request) {
            return ClientCalls.oneToOne(this.ctx, request, this.delegateStub::memberUpdate);
        }

        public Future<MemberListResponse> memberList(MemberListRequest request) {
            return ClientCalls.oneToOne(this.ctx, request, this.delegateStub::memberList);
        }
    }
}

