/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.etcd.jetcd.resolver;

import alluxio.shaded.client.com.google.common.base.Strings;
import alluxio.shaded.client.io.etcd.jetcd.common.exception.ErrorCode;
import alluxio.shaded.client.io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import alluxio.shaded.client.io.etcd.jetcd.resolver.AbstractNameResolver;
import alluxio.shaded.client.io.grpc.Attributes;
import alluxio.shaded.client.io.grpc.EquivalentAddressGroup;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;

public class HttpsNameResolver
extends AbstractNameResolver {
    public static final String SCHEME = "https";
    private final URI address;

    public HttpsNameResolver(URI targetUri) {
        super(targetUri);
        this.address = targetUri;
    }

    @Override
    protected List<EquivalentAddressGroup> computeAddressGroups() {
        if (this.address == null) {
            throw EtcdExceptionFactory.newEtcdException(ErrorCode.INVALID_ARGUMENT, "Unable to resolve endpoint " + this.getTargetUri());
        }
        return Collections.singletonList(new EquivalentAddressGroup(new InetSocketAddress(this.address.getHost(), this.address.getPort() != -1 ? this.address.getPort() : 2379), Strings.isNullOrEmpty(this.getServiceAuthority()) ? Attributes.newBuilder().set(EquivalentAddressGroup.ATTR_AUTHORITY_OVERRIDE, this.address.toString()).build() : Attributes.EMPTY));
    }
}

