/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.impl.launcher.commands;

import alluxio.shaded.client.io.vertx.core.cli.annotations.Argument;
import alluxio.shaded.client.io.vertx.core.cli.annotations.Description;
import alluxio.shaded.client.io.vertx.core.cli.annotations.Hidden;
import alluxio.shaded.client.io.vertx.core.cli.annotations.Name;
import alluxio.shaded.client.io.vertx.core.cli.annotations.Option;
import alluxio.shaded.client.io.vertx.core.cli.annotations.Summary;
import alluxio.shaded.client.io.vertx.core.impl.launcher.commands.ExecUtils;
import alluxio.shaded.client.io.vertx.core.spi.launcher.DefaultCommand;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Name(value="stop")
@Summary(value="Stop a vert.x application")
@Description(value="This command stops a vert.x application started with the `start` command. The command requires the application id as argument. Use the `list` command to get the list of applications")
public class StopCommand
extends DefaultCommand {
    private String id;
    private boolean redeploy;
    private static final Pattern PS = Pattern.compile("([0-9]+)\\s.*-Dvertx.id=.*");

    @Argument(index=0, argName="vertx.id", required=false)
    @Description(value="The vert.x application id")
    public void setApplicationId(String id) {
        this.id = id;
    }

    @Option(longName="redeploy", flag=true)
    @Hidden
    public void setRedeploy(boolean redeploy) {
        this.redeploy = redeploy;
    }

    @Override
    public void run() {
        if (this.id == null) {
            this.out.println("Application id not specified...");
            this.executionContext.execute("list", new String[0]);
            return;
        }
        this.out.println("Stopping vert.x application '" + this.id + "'");
        if (ExecUtils.isWindows()) {
            this.terminateWindowsApplication();
        } else {
            this.terminateLinuxApplication();
        }
    }

    private void terminateLinuxApplication() {
        block5: {
            String pid = this.pid();
            if (pid == null) {
                this.out.println("Cannot find process for application using the id '" + this.id + "'.");
                if (!this.redeploy) {
                    ExecUtils.exitBecauseOfProcessIssue();
                }
                return;
            }
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("kill");
            cmd.add(pid);
            try {
                int result = new ProcessBuilder(cmd).start().waitFor();
                this.out.println("Application '" + this.id + "' terminated with status " + result);
                if (!this.redeploy) {
                    ExecUtils.exit(result);
                }
            }
            catch (Exception e) {
                this.out.println("Failed to stop application '" + this.id + "'");
                e.printStackTrace(this.out);
                if (this.redeploy) break block5;
                ExecUtils.exitBecauseOfProcessIssue();
            }
        }
    }

    private void terminateWindowsApplication() {
        block3: {
            String filter = "Name LIKE 'java%' AND CommandLine LIKE '%-Dvertx.id=" + this.id + "%'";
            String command = "\"Get-CimInstance -ClassName Win32_Process -Filter \\\"" + filter + "\\\" | Invoke-CimMethod -MethodName Terminate\"";
            List<String> cmd = Arrays.asList("powershell", "-Command", command);
            try {
                Process process = new ProcessBuilder(cmd).start();
                int result = process.waitFor();
                this.out.println("Application '" + this.id + "' terminated with status " + result);
                if (!this.redeploy) {
                    ExecUtils.exit(result);
                }
            }
            catch (Exception e) {
                this.out.println("Failed to stop application '" + this.id + "'");
                e.printStackTrace(this.out);
                if (this.redeploy) break block3;
                ExecUtils.exitBecauseOfProcessIssue();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String pid() {
        try {
            Process process = new ProcessBuilder(Arrays.asList("sh", "-c", "ps ax | grep \"" + this.id + "\"")).start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    Matcher matcher = PS.matcher(line);
                    if (!matcher.find()) continue;
                    String string = matcher.group(1);
                    return string;
                }
                process.waitFor();
                return null;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace(this.out);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace(this.out);
        }
        return null;
    }
}

