/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.AlluxioURI;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.underfs.UfsStatus;
import java.util.Optional;
import java.util.stream.Stream;

public class UfsLoadResult {
    private final Stream<UfsStatus> mItems;
    private final String mContinuationToken;
    private final boolean mIsTruncated;
    private final int mItemsCount;
    private final AlluxioURI mLastItem;
    private final boolean mFirstIsFile;
    private final boolean mIsObjectStore;

    public UfsLoadResult(Stream<UfsStatus> items, int itemsCount, @Nullable String continuationToken, @Nullable AlluxioURI lastItem, boolean isTruncated, boolean firstIsFile, boolean isObjectStore) {
        this.mItems = items;
        this.mContinuationToken = continuationToken;
        this.mIsTruncated = isTruncated;
        this.mItemsCount = itemsCount;
        this.mLastItem = lastItem;
        this.mFirstIsFile = firstIsFile;
        this.mIsObjectStore = isObjectStore;
    }

    public boolean isIsObjectStore() {
        return this.mIsObjectStore;
    }

    public boolean isFirstFile() {
        return this.mFirstIsFile;
    }

    public Optional<AlluxioURI> getLastItem() {
        return Optional.ofNullable(this.mLastItem);
    }

    public int getItemsCount() {
        return this.mItemsCount;
    }

    public boolean isTruncated() {
        return this.mIsTruncated;
    }

    public Stream<UfsStatus> getItems() {
        return this.mItems;
    }

    public String getContinuationToken() {
        return this.mContinuationToken;
    }
}

