/*
 * The Alluxio Open Foundation licenses this work under the Apache License, version 2.0
 * (the "License"). You may not use this work except in alluxio.shaded.client.com.liance with the License, which is
 * available at www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied, as more fully set forth in the License.
 *
 * See the NOTICE file distributed with this work for information regarding copyright ownership.
 */

package alluxio;

/**
 * Project constants from alluxio.shaded.client.com.ilation time by maven.
 */
public final class ProjectConstants {
  /* Project version, specified in maven property. **/
  public static final String VERSION = "313";
  /* The latest git revision of at the time of building**/
  public static final String REVISION = "0814f34f9ad599b743a70df3e70cdbdb3a162c54";
  /* Hadoop version, specified in maven property. **/
  public static final String HADOOP_VERSION = "3.3.1";
  /* Whether update check is configurable. **/
  public static final String UPDATE_CHECK_CONFIGURABLE = "true";
  /* Whether update check is enabled. **/
  public static final String UPDATE_CHECK_ENABLED = "true";
  /* Update check host. **/
  public static final String UPDATE_CHECK_HOST = "https://diagnostics.alluxio.alluxio.shaded.client.io.;
  /* Update check auth string. **/
  public static final String UPDATE_CHECK_MAGIC_NUMBER = "YWxsdXhpbzp0YWNoeW9u";

  private ProjectConstants() {} // prevent instantiation
}
