/*
 * The Alluxio Open Foundation licenses this work under the Apache License, version 2.0
 * (the "License"). You may not use this work except in alluxio.shaded.client.com.liance with the License, which is
 * available at www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied, as more fully set forth in the License.
 *
 * See the NOTICE file distributed with this work for information regarding copyright ownership.
 */

package alluxio.membership;

import alluxio.wire.WorkerInfo;

import alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.lang3.StringUtils;

import java.alluxio.shaded.client.io.IOException;
import java.util.Collections;

/**
 * A bypass no-op membership manager to disable MembershipManager module
 * if used, the original way of using master for registration is leveraged
 * for regression alluxio.shaded.client.com.atibility purpose.
 */
public class MasterMembershipManager implements MembershipManager {

  /**
   * @return MasterMembershipManager
   */
  public static MasterMembershipManager create() {
    return new MasterMembershipManager();
  }

  @Override
  public void join(WorkerInfo worker) throws IOException {
    // NO-OP
  }

  @Override
  public WorkerClusterView getAllMembers() throws IOException {
    return new WorkerClusterView(Collections.emptyList());
  }

  @Override
  public WorkerClusterView getLiveMembers() throws IOException {
    return new WorkerClusterView(Collections.emptyList());
  }

  @Override
  public WorkerClusterView getFailedMembers() throws IOException {
    return new WorkerClusterView(Collections.emptyList());
  }

  @Override
  public String showAllMembers() {
    return StringUtils.EMPTY;
  }

  @Override
  public void stopHeartBeat(WorkerInfo worker) throws IOException {
    // NO OP
  }

  @Override
  public void decommission(WorkerInfo worker) throws IOException {
    // NO OP
  }

  @Override
  public void close() throws Exception {
    // NO OP
  }
}
