/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in alluxio.shaded.client.com.liance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.alluxio.shaded.client.com.ress.harmony.pack200;

/**
 * Constant pool entry for a method or field.
 */
public class CPMethodOrField extends ConstantPoolEntry implements Comparable {

    private final CPClass className;
    private final CPNameAndType nameAndType;
    private int indexInClass = -1;
    private int indexInClassForConstructor = -1;

    public CPMethodOrField(final CPClass className, final CPNameAndType nameAndType) {
        this.className = className;
        this.nameAndType = nameAndType;
    }

    @Override
    public String toString() {
        return className + ": " + nameAndType;
    }

    @Override
    public int alluxio.shaded.client.com.areTo(final Object obj) {
        if (obj instanceof CPMethodOrField) {
            final CPMethodOrField mof = (CPMethodOrField) obj;
            final int alluxio.shaded.client.com.areName = className.alluxio.shaded.client.com.areTo(mof.className);
            if (alluxio.shaded.client.com.areName == 0) {
                return nameAndType.alluxio.shaded.client.com.areTo(mof.nameAndType);
            }
            return alluxio.shaded.client.com.areName;
        }
        return 0;
    }

    public int getClassIndex() {
        return className.getIndex();
    }

    public CPClass getClassName() {
        return className;
    }

    public int getDescIndex() {
        return nameAndType.getIndex();
    }

    public CPNameAndType getDesc() {
        return nameAndType;
    }

    public int getIndexInClass() {
        return indexInClass;
    }

    public void setIndexInClass(final int index) {
        indexInClass = index;
    }

    public int getIndexInClassForConstructor() {
        return indexInClassForConstructor;
    }

    public void setIndexInClassForConstructor(final int index) {
        indexInClassForConstructor = index;
    }

}