/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.file.dora.MaglevHashProvider;
import alluxio.client.file.dora.WorkerLocationPolicy;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.ResourceExhaustedException;
import alluxio.membership.WorkerClusterView;
import alluxio.shaded.client.com.google.common.collect.ImmutableCollection;
import alluxio.shaded.client.com.google.common.collect.ImmutableList;
import alluxio.wire.WorkerIdentity;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerState;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaglevHashPolicy
implements WorkerLocationPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(MaglevHashPolicy.class);
    private final MaglevHashProvider mHashProvider;

    public MaglevHashPolicy(AlluxioConfiguration conf) {
        LOG.debug("%s is chosen for user worker hash algorithm", (Object)conf.getString(PropertyKey.USER_WORKER_SELECTION_POLICY));
        int lookupSize = conf.getInt(PropertyKey.USER_MAGLEV_HASH_LOOKUP_SIZE);
        this.mHashProvider = new MaglevHashProvider(100, 1000L, lookupSize);
        if (!this.isPrime(lookupSize)) {
            System.out.println("The number of alluxio.user.maglev.hash.lookup.size must be a prime number!");
        }
    }

    @Override
    public List<BlockWorkerInfo> getPreferredWorkers(WorkerClusterView workerClusterView, String fileId, int count) throws ResourceExhaustedException {
        if (workerClusterView.size() < count) {
            throw new ResourceExhaustedException(String.format("Not enough workers in the cluster %d workers in the cluster but %d required", workerClusterView.size(), count));
        }
        Set<WorkerIdentity> workerIdentities = workerClusterView.workerIds();
        this.mHashProvider.refresh(workerIdentities);
        List<WorkerIdentity> workers = this.mHashProvider.getMultiple(fileId, count);
        if (workers.size() != count) {
            throw new ResourceExhaustedException(String.format("Found %d workers from the hash ring but %d required", workers.size(), count));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (WorkerIdentity worker : workers) {
            Optional<WorkerInfo> optionalWorkerInfo = workerClusterView.getWorkerById(worker);
            if (!optionalWorkerInfo.isPresent()) {
                LOG.debug("Inconsistency between caller's view of cluster and that of the consistent hash policy's: worker {} selected by policy does not exist in caller's view {}. Skipping this worker.", (Object)worker, (Object)workerClusterView);
                continue;
            }
            WorkerInfo workerInfo = optionalWorkerInfo.get();
            BlockWorkerInfo blockWorkerInfo = new BlockWorkerInfo(worker, workerInfo.getAddress(), workerInfo.getCapacityBytes(), workerInfo.getUsedBytes(), workerInfo.getState() == WorkerState.LIVE);
            builder.add(blockWorkerInfo);
        }
        ImmutableCollection infos = builder.build();
        return infos;
    }

    private boolean isPrime(int n) {
        if (n <= 1) {
            return false;
        }
        int i = 2;
        while (i * i <= n) {
            if (n % i == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

