/*
 * Decompiled with CFR 0.152.
 */
package alluxio.membership;

import alluxio.membership.AlluxioEtcdClient;
import alluxio.shaded.client.com.google.gson.Gson;
import alluxio.shaded.client.com.google.gson.GsonBuilder;
import alluxio.shaded.client.com.google.gson.InstanceCreator;
import alluxio.shaded.client.com.google.gson.annotations.Expose;
import alluxio.shaded.client.com.google.gson.annotations.SerializedName;
import alluxio.shaded.client.io.etcd.jetcd.support.CloseableClient;
import alluxio.shaded.client.javax.annotation.concurrent.GuardedBy;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public abstract class DefaultServiceEntity
implements Closeable {
    private CloseableClient mKeepAliveClient;
    private AlluxioEtcdClient.Lease mLease = null;
    private long mLeaseTTLInSec = 5L;
    private long mLeaseTimeoutInSec = 5L;
    @Expose
    @SerializedName(value="ServiceEntityName")
    protected String mServiceEntityName;
    protected long mRevision;
    public final ReentrantLock mLock = new ReentrantLock();
    public AtomicBoolean mNeedReconnect = new AtomicBoolean(false);

    public DefaultServiceEntity() {
    }

    public DefaultServiceEntity(String serviceEntityName) {
        this.mServiceEntityName = serviceEntityName;
    }

    public String getServiceEntityName() {
        return this.mServiceEntityName;
    }

    public void setKeepAliveClient(CloseableClient keepAliveClient) {
        this.mKeepAliveClient = keepAliveClient;
    }

    public CloseableClient getKeepAliveClient() {
        return this.mKeepAliveClient;
    }

    public AlluxioEtcdClient.Lease getLease() {
        return this.mLease;
    }

    @GuardedBy(value="mLock")
    public void setLease(AlluxioEtcdClient.Lease lease) {
        this.mLease = lease;
    }

    public long getRevisionNumber() {
        return this.mRevision;
    }

    public void setRevisionNumber(long revisionNumber) {
        this.mRevision = revisionNumber;
    }

    ReentrantLock getLock() {
        return this.mLock;
    }

    public long getLeaseTTLInSec() {
        return this.mLeaseTTLInSec;
    }

    public void setLeaseTTLInSec(long ttl) {
        this.mLeaseTTLInSec = ttl;
    }

    public long getLeaseTimeoutInSec() {
        return this.mLeaseTimeoutInSec;
    }

    public void setLeaseTimeoutInSec(long timeout) {
        this.mLeaseTimeoutInSec = timeout;
    }

    public byte[] serialize() {
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        return gson.toJson(this).getBytes(StandardCharsets.UTF_8);
    }

    public void deserialize(byte[] buf) {
        DefaultServiceEntity obj = this;
        InstanceCreator<DefaultServiceEntity> creator = type -> obj;
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter((Type)((Object)DefaultServiceEntity.class), creator).create();
        gson.fromJson((Reader)new InputStreamReader(new ByteArrayInputStream(buf)), DefaultServiceEntity.class);
    }

    @Override
    public void close() throws IOException {
        if (this.mKeepAliveClient != null) {
            this.mKeepAliveClient.close();
        }
    }
}

