/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.etcd.jetcd.op;

import alluxio.shaded.client.com.google.protobuf.ByteString;
import alluxio.shaded.client.io.etcd.jetcd.ByteSequence;
import alluxio.shaded.client.io.etcd.jetcd.api.Compare;

public abstract class CmpTarget<T> {
    private final Compare.CompareTarget target;
    private final T targetValue;

    public static VersionCmpTarget version(long version) {
        return new VersionCmpTarget(version);
    }

    public static CreateRevisionCmpTarget createRevision(long revision) {
        return new CreateRevisionCmpTarget(revision);
    }

    public static ModRevisionCmpTarget modRevision(long revision) {
        return new ModRevisionCmpTarget(revision);
    }

    public static ValueCmpTarget value(ByteSequence value) {
        return new ValueCmpTarget(ByteString.copyFrom(value.getBytes()));
    }

    protected CmpTarget(Compare.CompareTarget target, T targetValue) {
        this.target = target;
        this.targetValue = targetValue;
    }

    public Compare.CompareTarget getTarget() {
        return this.target;
    }

    public T getTargetValue() {
        return this.targetValue;
    }

    public static final class ValueCmpTarget
    extends CmpTarget<ByteString> {
        ValueCmpTarget(ByteString targetValue) {
            super(Compare.CompareTarget.VALUE, targetValue);
        }
    }

    public static final class ModRevisionCmpTarget
    extends CmpTarget<Long> {
        ModRevisionCmpTarget(Long targetValue) {
            super(Compare.CompareTarget.MOD, targetValue);
        }
    }

    public static final class CreateRevisionCmpTarget
    extends CmpTarget<Long> {
        CreateRevisionCmpTarget(Long targetValue) {
            super(Compare.CompareTarget.CREATE, targetValue);
        }
    }

    public static final class VersionCmpTarget
    extends CmpTarget<Long> {
        VersionCmpTarget(Long targetValue) {
            super(Compare.CompareTarget.VERSION, targetValue);
        }
    }
}

