/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.etcd.jetcd.watch;

import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.io.etcd.jetcd.ByteSequence;
import alluxio.shaded.client.io.etcd.jetcd.KeyValue;
import alluxio.shaded.client.io.etcd.jetcd.api.Event;
import alluxio.shaded.client.io.etcd.jetcd.impl.AbstractResponse;
import alluxio.shaded.client.io.etcd.jetcd.watch.WatchEvent;
import java.util.List;
import java.util.stream.Collectors;

public class WatchResponse
extends AbstractResponse<alluxio.shaded.client.io.etcd.jetcd.api.WatchResponse> {
    private List<WatchEvent> events;
    private final ByteSequence namespace;

    public WatchResponse(alluxio.shaded.client.io.etcd.jetcd.api.WatchResponse response, ByteSequence namespace) {
        super(response, response.getHeader());
        this.namespace = namespace;
    }

    @VisibleForTesting
    public WatchResponse(alluxio.shaded.client.io.etcd.jetcd.api.WatchResponse response) {
        this(response, ByteSequence.EMPTY);
    }

    private static WatchEvent toEvent(Event event, ByteSequence namespace) {
        WatchEvent.EventType eventType;
        switch (event.getType()) {
            case DELETE: {
                eventType = WatchEvent.EventType.DELETE;
                break;
            }
            case PUT: {
                eventType = WatchEvent.EventType.PUT;
                break;
            }
            default: {
                eventType = WatchEvent.EventType.UNRECOGNIZED;
            }
        }
        return new WatchEvent(new KeyValue(event.getKv(), namespace), new KeyValue(event.getPrevKv(), namespace), eventType);
    }

    public synchronized List<WatchEvent> getEvents() {
        if (this.events == null) {
            this.events = ((alluxio.shaded.client.io.etcd.jetcd.api.WatchResponse)this.getResponse()).getEventsList().stream().map(event -> WatchResponse.toEvent(event, this.namespace)).collect(Collectors.toList());
        }
        return this.events;
    }

    public boolean isProgressNotify() {
        return WatchResponse.isProgressNotify((alluxio.shaded.client.io.etcd.jetcd.api.WatchResponse)this.getResponse());
    }

    public static boolean isProgressNotify(alluxio.shaded.client.io.etcd.jetcd.api.WatchResponse response) {
        return response.getEventsCount() == 0 && !response.getCreated() && !response.getCanceled() && response.getCompactRevision() == 0L && response.getHeader().getRevision() != 0L;
    }
}

