/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.http.impl;

import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import alluxio.shaded.client.io.netty.buffer.Unpooled;
import alluxio.shaded.client.io.netty.channel.ChannelHandlerContext;
import alluxio.shaded.client.io.netty.channel.FileRegion;
import alluxio.shaded.client.io.netty.handler.codec.http.FullHttpMessage;
import alluxio.shaded.client.io.netty.handler.codec.http.HttpContent;
import alluxio.shaded.client.io.netty.handler.codec.http.LastHttpContent;
import alluxio.shaded.client.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import alluxio.shaded.client.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import alluxio.shaded.client.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import alluxio.shaded.client.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import alluxio.shaded.client.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import alluxio.shaded.client.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import alluxio.shaded.client.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import alluxio.shaded.client.io.netty.handler.stream.ChunkedFile;
import alluxio.shaded.client.io.vertx.codegen.annotations.Nullable;
import alluxio.shaded.client.io.vertx.core.AsyncResult;
import alluxio.shaded.client.io.vertx.core.Future;
import alluxio.shaded.client.io.vertx.core.Handler;
import alluxio.shaded.client.io.vertx.core.buffer.Buffer;
import alluxio.shaded.client.io.vertx.core.http.GoAway;
import alluxio.shaded.client.io.vertx.core.http.Http2Settings;
import alluxio.shaded.client.io.vertx.core.http.HttpConnection;
import alluxio.shaded.client.io.vertx.core.http.WebSocketFrameType;
import alluxio.shaded.client.io.vertx.core.http.impl.AssembledHttpResponse;
import alluxio.shaded.client.io.vertx.core.http.impl.WebSocketImplBase;
import alluxio.shaded.client.io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import alluxio.shaded.client.io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import alluxio.shaded.client.io.vertx.core.impl.ContextInternal;
import alluxio.shaded.client.io.vertx.core.net.impl.ConnectionBase;
import alluxio.shaded.client.io.vertx.core.net.impl.VertxHandler;

abstract class Http1xConnectionBase<S extends WebSocketImplBase<S>>
extends ConnectionBase
implements HttpConnection {
    protected S webSocket;

    Http1xConnectionBase(ContextInternal context, ChannelHandlerContext chctx) {
        super(context, chctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleWsFrame(WebSocketFrame msg) {
        S w;
        WebSocketFrameInternal frame = this.decodeFrame(msg);
        Http1xConnectionBase http1xConnectionBase = this;
        synchronized (http1xConnectionBase) {
            w = this.webSocket;
        }
        if (w != null) {
            ((WebSocketImplBase)w).context.execute(frame, arg_0 -> w.handleFrame(arg_0));
        }
    }

    private WebSocketFrameInternal decodeFrame(WebSocketFrame msg) {
        WebSocketFrameType frameType;
        ByteBuf payload = VertxHandler.safeBuffer(msg.content());
        boolean isFinal = msg.isFinalFragment();
        if (msg instanceof BinaryWebSocketFrame) {
            frameType = WebSocketFrameType.BINARY;
        } else if (msg instanceof CloseWebSocketFrame) {
            frameType = WebSocketFrameType.CLOSE;
        } else if (msg instanceof PingWebSocketFrame) {
            frameType = WebSocketFrameType.PING;
        } else if (msg instanceof PongWebSocketFrame) {
            frameType = WebSocketFrameType.PONG;
        } else if (msg instanceof TextWebSocketFrame) {
            frameType = WebSocketFrameType.TEXT;
        } else if (msg instanceof ContinuationWebSocketFrame) {
            frameType = WebSocketFrameType.CONTINUATION;
        } else {
            throw new IllegalStateException("Unsupported WebSocket msg " + msg);
        }
        return new WebSocketFrameImpl(frameType, payload, isFinal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> close() {
        S sock;
        Http1xConnectionBase http1xConnectionBase = this;
        synchronized (http1xConnectionBase) {
            sock = this.webSocket;
        }
        if (sock == null) {
            return super.close();
        }
        ((WebSocketImplBase)sock).close();
        return this.closeFuture();
    }

    @Override
    public Http1xConnectionBase closeHandler(Handler<Void> handler) {
        return (Http1xConnectionBase)super.closeHandler(handler);
    }

    @Override
    public Http1xConnectionBase exceptionHandler(Handler<Throwable> handler) {
        return (Http1xConnectionBase)super.exceptionHandler(handler);
    }

    @Override
    public HttpConnection goAway(long errorCode, int lastStreamId, Buffer debugData) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support GOAWAY");
    }

    @Override
    public HttpConnection goAwayHandler(@Nullable Handler<GoAway> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support GOAWAY");
    }

    @Override
    public HttpConnection shutdownHandler(@Nullable Handler<Void> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections cannot be shutdown");
    }

    @Override
    public void shutdown(long timeout, Handler<AsyncResult<Void>> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections cannot be shutdown");
    }

    @Override
    public Future<Void> shutdown(long timeoutMs) {
        throw new UnsupportedOperationException("HTTP/1.x connections cannot be shutdown");
    }

    @Override
    public Http2Settings settings() {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public Future<Void> updateSettings(Http2Settings settings) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public HttpConnection updateSettings(Http2Settings settings, Handler<AsyncResult<Void>> completionHandler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public Http2Settings remoteSettings() {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public HttpConnection remoteSettingsHandler(Handler<Http2Settings> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public HttpConnection ping(Buffer data, Handler<AsyncResult<Buffer>> pongHandler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support PING");
    }

    @Override
    public HttpConnection pingHandler(@Nullable Handler<Buffer> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support PING");
    }

    @Override
    public Future<Buffer> ping(Buffer data) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support PING");
    }

    @Override
    protected void reportsBytesWritten(Object msg) {
        long size = Http1xConnectionBase.sizeOf(msg);
        this.reportBytesWritten(size);
    }

    @Override
    protected void reportBytesRead(Object msg) {
        long size = Http1xConnectionBase.sizeOf(msg);
        this.reportBytesRead(size);
    }

    static long sizeOf(WebSocketFrame obj) {
        return obj.content().readableBytes();
    }

    static long sizeOf(Object obj) {
        if (obj == Unpooled.EMPTY_BUFFER || obj == LastHttpContent.EMPTY_LAST_CONTENT) {
            return 0L;
        }
        if (obj instanceof AssembledHttpResponse) {
            return ((AssembledHttpResponse)obj).content().readableBytes();
        }
        if (obj instanceof Buffer) {
            return ((Buffer)obj).length();
        }
        if (obj instanceof ByteBuf) {
            return ((ByteBuf)obj).readableBytes();
        }
        if (obj instanceof FullHttpMessage) {
            return ((FullHttpMessage)obj).content().readableBytes();
        }
        if (obj instanceof LastHttpContent) {
            return ((LastHttpContent)obj).content().readableBytes();
        }
        if (obj instanceof HttpContent) {
            return ((HttpContent)obj).content().readableBytes();
        }
        if (obj instanceof WebSocketFrame) {
            return Http1xConnectionBase.sizeOf((WebSocketFrame)obj);
        }
        if (obj instanceof FileRegion) {
            return ((FileRegion)obj).count();
        }
        if (obj instanceof ChunkedFile) {
            ChunkedFile file = (ChunkedFile)obj;
            return file.endOffset() - file.startOffset();
        }
        return 0L;
    }
}

