/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.impl.verticle;

import alluxio.shaded.client.javax.tools.JavaFileObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

public class JavaSourceContext {
    private final String className;
    private final File sourceRoot;

    public JavaSourceContext(File file) {
        String packageName = JavaSourceContext.parsePackage(file);
        File rootDirectory = file.getParentFile();
        if (packageName != null) {
            String[] pathTokens = packageName.split("\\.");
            for (int i = pathTokens.length - 1; i >= 0; --i) {
                String token = pathTokens[i];
                if (!token.equals(rootDirectory.getName())) {
                    throw new RuntimeException("Package structure does not match directory structure: " + token + " != " + rootDirectory.getName());
                }
                rootDirectory = rootDirectory.getParentFile();
            }
        }
        this.sourceRoot = rootDirectory;
        String fileName = file.getName();
        String className = fileName.substring(0, fileName.length() - JavaFileObject.Kind.SOURCE.extension.length());
        if (packageName != null) {
            className = packageName + '.' + className;
        }
        this.className = className;
    }

    public File getSourceRoot() {
        return this.sourceRoot;
    }

    public String getClassName() {
        return this.className;
    }

    private static String parsePackage(File file) {
        try {
            String source = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
            source = source.replaceAll("//.*|(\"(?:\\\\[^\"]|\\\\\"|.)*?\")|(?s)/\\*.*?\\*/", "$1 ");
            for (String line : source.split("\\r?\\n")) {
                if ((line = line.trim()).isEmpty()) continue;
                int idx = line.indexOf("package ");
                if (idx != -1) {
                    return line.substring(line.indexOf(32, idx), line.indexOf(59, idx)).trim();
                }
                return null;
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

