/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.json.jackson;

import alluxio.shaded.client.com.fasterxml.jackson.core.JsonParser;
import alluxio.shaded.client.com.fasterxml.jackson.core.JsonProcessingException;
import alluxio.shaded.client.com.fasterxml.jackson.databind.DeserializationContext;
import alluxio.shaded.client.com.fasterxml.jackson.databind.JsonDeserializer;
import alluxio.shaded.client.com.fasterxml.jackson.databind.exc.InvalidFormatException;
import alluxio.shaded.client.io.vertx.core.json.impl.JsonUtil;
import java.io.IOException;
import java.time.Instant;

class ByteArrayDeserializer
extends JsonDeserializer<byte[]> {
    ByteArrayDeserializer() {
    }

    @Override
    public byte[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String text = p.getText();
        try {
            return JsonUtil.BASE64_DECODER.decode(text);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(p, "Expected a base64 encoded byte array", (Object)text, Instant.class);
        }
    }
}

