/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.net;

import alluxio.shaded.client.javax.net.ssl.ManagerFactoryParameters;
import alluxio.shaded.client.javax.net.ssl.TrustManager;
import alluxio.shaded.client.javax.net.ssl.TrustManagerFactory;
import alluxio.shaded.client.javax.net.ssl.TrustManagerFactorySpi;
import java.security.KeyStore;
import java.security.Provider;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TrustManagerFactoryWrapper
extends TrustManagerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrustManagerFactoryWrapper.class);
    private static final String KEY_MANAGER_FACTORY_ALGORITHM = "no-algorithm";
    private static final Provider PROVIDER = new Provider("", 1.0, ""){};

    TrustManagerFactoryWrapper(TrustManager trustManager) {
        super((TrustManagerFactorySpi)new TrustManagerFactorySpiWrapper(trustManager), PROVIDER, KEY_MANAGER_FACTORY_ALGORITHM);
    }

    private static class TrustManagerFactorySpiWrapper
    extends TrustManagerFactorySpi {
        private final TrustManager[] trustManagers;

        private TrustManagerFactorySpiWrapper(TrustManager trustManager) {
            Objects.requireNonNull(trustManager);
            this.trustManagers = new TrustManager[]{trustManager};
        }

        protected void engineInit(KeyStore keyStore) {
            LOGGER.info("Ignoring provided KeyStore");
        }

        protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
            LOGGER.info("Ignoring provided ManagerFactoryParameters");
        }

        protected TrustManager[] engineGetTrustManagers() {
            return this.trustManagers;
        }
    }
}

