/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.spi.cluster.impl.selector;

import alluxio.shaded.client.io.vertx.core.spi.cluster.impl.selector.Index;
import alluxio.shaded.client.io.vertx.core.spi.cluster.impl.selector.RoundRobinSelector;
import java.util.Collections;
import java.util.List;

class SimpleRoundRobinSelector
implements RoundRobinSelector {
    private final List<String> nodeIds;
    private final Index index;

    SimpleRoundRobinSelector(List<String> nodeIds) {
        if (nodeIds.size() > 1) {
            this.nodeIds = Collections.unmodifiableList(nodeIds);
            this.index = new Index(nodeIds.size());
        } else {
            this.nodeIds = Collections.singletonList(nodeIds.get(0));
            this.index = null;
        }
    }

    @Override
    public String selectForSend() {
        if (this.index == null) {
            return this.nodeIds.get(0);
        }
        return this.nodeIds.get(this.index.nextVal());
    }

    @Override
    public Iterable<String> selectForPublish() {
        return this.nodeIds;
    }
}

