/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.net.jodah.failsafe;

import alluxio.shaded.client.net.jodah.failsafe.AbstractExecution;
import alluxio.shaded.client.net.jodah.failsafe.Policy;
import alluxio.shaded.client.net.jodah.failsafe.PolicyExecutor;
import alluxio.shaded.client.net.jodah.failsafe.PolicyListeners;
import alluxio.shaded.client.net.jodah.failsafe.TimeoutExecutor;
import alluxio.shaded.client.net.jodah.failsafe.internal.util.Assert;
import java.time.Duration;

public class Timeout<R>
extends PolicyListeners<Timeout<R>, R>
implements Policy<R> {
    private final Duration timeout;
    private volatile boolean interruptable;

    private Timeout(Duration timeout) {
        this.timeout = timeout;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public boolean canCancel() {
        return true;
    }

    public boolean canInterrupt() {
        return this.interruptable;
    }

    public Timeout<R> withCancel(boolean mayInterruptIfRunning) {
        this.interruptable = mayInterruptIfRunning;
        return this;
    }

    public Timeout<R> withInterrupt(boolean mayInterruptIfRunning) {
        this.interruptable = mayInterruptIfRunning;
        return this;
    }

    public static <R> Timeout<R> of(Duration timeout) {
        Assert.notNull(timeout, "timeout");
        Assert.isTrue(timeout.toNanos() > 0L, "timeout must be > 0", new Object[0]);
        return new Timeout<R>(timeout);
    }

    @Override
    public PolicyExecutor toExecutor(AbstractExecution execution) {
        return new TimeoutExecutor(this, execution);
    }
}

