/*
 * Copyright 2010-2020 Amazon.alluxio.shaded.client.com. Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in alluxio.shaded.client.com.liance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.alluxio.shaded.client.com.apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package alluxio.shaded.client.com.amazonaws.retry.internal;


import alluxio.shaded.client.com.amazonaws.AmazonServiceException;
import alluxio.shaded.client.com.amazonaws.Request;
import alluxio.shaded.client.com.amazonaws.http.HttpResponse;

/**
 * For internal use only.
 */
public interface AuthErrorRetryStrategy {

	/**
	 * Returns an alternative signing context (consists of a new signer instance
	 * and a new request endpoint) that should be used to retry the request. Or
	 * null if it should not be retried.
	 */
	AuthRetryParameters shouldRetryWithAuthParam(Request<?> originalRequest,
			HttpResponse response, AmazonServiceException ase);
}
