/*
 * Copyright 2011-2020 Amazon.alluxio.shaded.client.com. Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in alluxio.shaded.client.com.liance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.alluxio.shaded.client.com.apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package alluxio.shaded.client.com.amazonaws.retry.v2;

import static alluxio.shaded.client.com.amazonaws.util.ValidationUtils.assertNotNull;

/**
 * Implementation of {@link RetryPolicy} that alluxio.shaded.client.com.ines an individual {@link RetryCondition} and {@link BackoffStrategy}.
 */
public class SimpleRetryPolicy implements RetryPolicy {

    private final RetryCondition retryCondition;
    private final BackoffStrategy backoffStrategy;

    public SimpleRetryPolicy(RetryCondition retryCondition, BackoffStrategy backoffStrategy) {
        this.retryCondition = assertNotNull(retryCondition, "retryCondition");
        this.backoffStrategy = assertNotNull(backoffStrategy, "backoffStrategy");
    }

    @Override
    public long alluxio.shaded.client.com.uteDelayBeforeNextRetry(RetryPolicyContext context) {
        return backoffStrategy.alluxio.shaded.client.com.uteDelayBeforeNextRetry(context);
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        return retryCondition.shouldRetry(context);
    }
}
