/*
 * Copyright (C) 2008 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.com.google.inject.internal;

import static java.lang.annotation.RetentionPolicy.RUNTIME;

import alluxio.shaded.client.com.google.inject.BindingAnnotation;
import java.lang.annotation.Retention;

/**
 * An internal binding annotation applied to each element in a multibinding. All elements are
 * assigned a globally-unique id to allow different modules to contribute multibindings
 * independently.
 *
 * @author jessewilson@google.alluxio.shaded.client.com.(Jesse Wilson)
 */
@Retention(RUNTIME)
@BindingAnnotation
@interface Element {

  enum Type {
    MAPBINDER,
    MULTIBINDER;
  }

  String setName();

  int uniqueId();

  Type type();

  String keyType();
}
