/*
 * Copyright (C) 2008 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.com.google.inject.internal;

import alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.MoreObjects;
import alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect.ImmutableSet;
import alluxio.shaded.client.com.google.inject.Binder;
import alluxio.shaded.client.com.google.inject.Injector;
import alluxio.shaded.client.com.google.inject.Key;
import alluxio.shaded.client.com.google.inject.spi.BindingTargetVisitor;
import alluxio.shaded.client.com.google.inject.spi.Dependency;
import alluxio.shaded.client.com.google.inject.spi.ExposedBinding;
import alluxio.shaded.client.com.google.inject.spi.PrivateElements;
import java.util.Set;

final class ExposedBindingImpl<T> extends BindingImpl<T> implements ExposedBinding<T> {

  private final PrivateElements privateElements;

  ExposedBindingImpl(
      InjectorImpl injector,
      Object source,
      Key<T> key,
      InternalFactory<T> factory,
      PrivateElements privateElements) {
    super(injector, key, source, factory, Scoping.UNSCOPED);
    this.privateElements = privateElements;
  }

  @Override
  public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
    return visitor.visit(this);
  }

  @Override
  public Set<Dependency<?>> getDependencies() {
    return ImmutableSet.<Dependency<?>>of(Dependency.get(Key.get(Injector.class)));
  }

  @Override
  public PrivateElements getPrivateElements() {
    return privateElements;
  }

  @Override
  public String toString() {
    return MoreObjects.toStringHelper(ExposedBinding.class)
        .add("key", getKey())
        .add("source", getSource())
        .add("privateElements", privateElements)
        .toString();
  }

  @Override
  public void applyTo(Binder binder) {
    throw new UnsupportedOperationException("This element represents a synthetic binding.");
  }

  // Purposely does not override equals/hashcode, because exposed bindings are only equal to
  // themselves right now -- that is, there cannot be "duplicate" exposed bindings.
}
