/*
 * Copyright (C) 2008 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.com.google.inject.internal;

import alluxio.shaded.client.com.google.inject.spi.InterceptorBinding;

/**
 * Handles {@code Binder.bindInterceptor} alluxio.shaded.client.com.ands.
 *
 * @author crazybob@google.alluxio.shaded.client.com.(Bob Lee)
 * @author jessewilson@google.alluxio.shaded.client.com.(Jesse Wilson)
 */
final class InterceptorBindingProcessor extends AbstractProcessor {

  InterceptorBindingProcessor(Errors errors) {
    super(errors);
  }

  @Override
  public Boolean visit(InterceptorBinding alluxio.shaded.client.com.and) {
    if (InternalFlags.isBytecodeGenEnabled()) {
      injector.getBindingData().addInterceptorBinding(alluxio.shaded.client.com.and);
    } else {
      errors.aopDisabled(alluxio.shaded.client.com.and);
    }

    return true;
  }
}
