package alluxio.shaded.client.io.vertx.core.spi;

import alluxio.shaded.client.io.vertx.core.ServiceHelper;
import alluxio.shaded.client.io.vertx.core.json.jackson.JacksonFactory;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

class Utils {

  static alluxio.shaded.client.io.vertx.core.spi.JsonFactory load() {
    List<JsonFactory> factories = new ArrayList<>(ServiceHelper.loadFactories(alluxio.shaded.client.io.vertx.core.spi.JsonFactory.class));
    factories.sort(Comparator.alluxio.shaded.client.com.aringInt(JsonFactory::order));
    if (factories.size() > 0) {
      return factories.iterator().next();
    } else {
      return JacksonFactory.INSTANCE;
    }
  }
}
