/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.common;

import alluxio.client.ReadType;
import alluxio.stress.Parameters;
import alluxio.stress.common.FileSystemClientType;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;

public class FileSystemParameters
extends Parameters {
    @Parameter(names={"--client-type"}, description="the client API type. Alluxio native or hadoop compatible client, default is AlluxioHDFS", converter=FileSystemParametersClientTypeConverter.class)
    public FileSystemClientType mClientType = FileSystemClientType.ALLUXIO_HDFS;
    @Parameter(names={"--read-type"}, description="the cache mechanism during read. Options are [NONE, CACHE, CACHE_PROMOTE] default is CACHE", converter=FileSystemParametersReadTypeConverter.class)
    public ReadType mReadType = ReadType.CACHE;

    public static class FileSystemParametersReadTypeConverter
    implements IStringConverter<ReadType> {
        public ReadType convert(String value) {
            return ReadType.fromString((String)value);
        }
    }

    public static class FileSystemParametersClientTypeConverter
    implements IStringConverter<FileSystemClientType> {
        public FileSystemClientType convert(String value) {
            return FileSystemClientType.fromString(value);
        }
    }
}

