/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.client;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.stress.BaseParameters;
import alluxio.stress.GraphGenerator;
import alluxio.stress.Summary;
import alluxio.stress.TaskResult;
import alluxio.stress.client.CompactionParameters;
import alluxio.stress.client.CompactionTaskResultStatistics;
import alluxio.stress.common.SummaryStatistics;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.DataFormatException;
import javax.annotation.Nullable;

public class CompactionTaskResult
implements TaskResult {
    private BaseParameters mBaseParameters;
    private CompactionParameters mParameters;
    private List<String> mErrors;
    private CompactionTaskResultStatistics mStatistics;

    public CompactionTaskResult() {
        this.mErrors = new ArrayList<String>();
        this.mStatistics = new CompactionTaskResultStatistics();
    }

    public CompactionTaskResult(CompactionTaskResult from) {
        this.mBaseParameters = from.mBaseParameters;
        this.mParameters = from.mParameters;
        this.mErrors = from.mErrors;
        this.mStatistics = from.mStatistics;
    }

    @Override
    @Nullable
    public BaseParameters getBaseParameters() {
        return this.mBaseParameters;
    }

    public void setBaseParameters(BaseParameters baseParameters) {
        this.mBaseParameters = baseParameters;
    }

    @Nullable
    public CompactionParameters getParameters() {
        return this.mParameters;
    }

    public void setParameters(CompactionParameters parameters) {
        this.mParameters = parameters;
    }

    public void addError(String errorMsg) {
        this.mErrors.add(errorMsg);
    }

    @Override
    public List<String> getErrors() {
        return this.mErrors;
    }

    public void setErrors(List<String> errors) {
        this.mErrors = errors;
    }

    public void merge(CompactionTaskResult toMerge) throws Exception {
        this.mStatistics.merge(toMerge.getStatistics());
        this.mErrors.addAll(toMerge.getErrors());
    }

    public void incrementNumSuccess() {
        ++this.mStatistics.mNumSuccess;
    }

    public CompactionTaskResultStatistics getStatistics() {
        return this.mStatistics;
    }

    public void setStatistics(CompactionTaskResultStatistics statistics) {
        this.mStatistics = statistics;
    }

    @Override
    public Aggregator aggregator() {
        return new Aggregator();
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    public static class CompactionSummary
    implements Summary {
        @JsonProperty(value="baseParameters")
        private final BaseParameters mBaseParameters;
        @JsonProperty(value="parameters")
        private final CompactionParameters mParameters;
        @JsonProperty(value="numSuccess")
        private final long mNumSuccess;
        @JsonProperty(value="errors")
        private final List<String> mErrors;
        @JsonProperty(value="statistics")
        private final SummaryStatistics mSummaryStatistics;

        public CompactionSummary(CompactionTaskResult mergedResult) throws DataFormatException {
            this.mBaseParameters = mergedResult.getBaseParameters();
            this.mParameters = mergedResult.getParameters();
            this.mNumSuccess = mergedResult.getStatistics().mNumSuccess;
            this.mErrors = mergedResult.getErrors();
            this.mSummaryStatistics = mergedResult.getStatistics().toBenchSummaryStatistics();
        }

        @Override
        public GraphGenerator graphGenerator() {
            return null;
        }
    }

    private static final class Aggregator
    implements TaskResult.Aggregator<CompactionTaskResult> {
        private Aggregator() {
        }

        public CompactionSummary aggregate(Iterable<CompactionTaskResult> results) throws Exception {
            Iterator<CompactionTaskResult> iterator = results.iterator();
            if (!iterator.hasNext()) {
                return new CompactionSummary(new CompactionTaskResult());
            }
            CompactionTaskResult mergedResult = new CompactionTaskResult(iterator.next());
            while (iterator.hasNext()) {
                mergedResult.merge(iterator.next());
            }
            return new CompactionSummary(mergedResult);
        }
    }
}

