/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.fuse;

public enum FuseIOOperation {
    CLUSTER_READ("ClusterRead"),
    LIST_FILE("ListFile"),
    LOCAL_READ("LocalRead"),
    REMOTE_READ("RemoteRead"),
    WRITE("Write");

    private final String mName;

    public static boolean isRead(FuseIOOperation operation) {
        switch (operation) {
            case LOCAL_READ: 
            case REMOTE_READ: 
            case CLUSTER_READ: {
                return true;
            }
        }
        return false;
    }

    private FuseIOOperation(String name) {
        this.mName = name;
    }

    public String toString() {
        return this.mName;
    }

    public static FuseIOOperation fromString(String text) {
        for (FuseIOOperation type : FuseIOOperation.values()) {
            if (!type.toString().equalsIgnoreCase(text)) continue;
            return type;
        }
        throw new IllegalArgumentException("No constant with text " + text + " found");
    }
}

