/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.rpc;

import alluxio.stress.rpc.RpcBenchParameters;
import alluxio.stress.rpc.TierAlias;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BlockMasterBenchParameters
extends RpcBenchParameters {
    @Parameter(names={"--tiers"}, converter=TierParser.class, description="The number of blocks in each storage dir and tier. List tiers in the order of MEM, SSD and HDD separated by semicolon, list dirs inside each tier separated by comma. Example: \"100,200,300;1000,1500;2000\"")
    public Map<TierAlias, List<Integer>> mTiers;

    private static class TierParser
    implements IStringConverter<Map<TierAlias, List<Integer>>> {
        private TierParser() {
        }

        public Map<TierAlias, List<Integer>> convert(String tiersConfig) {
            String[] tiers = tiersConfig.split(";");
            int length = Math.min(tiers.length, TierAlias.values().length);
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (int i = 0; i < length; ++i) {
                builder.put((Object)TierAlias.SORTED.get(i), Arrays.stream(tiers[i].split(",")).map(Integer::parseInt).collect(Collectors.toList()));
            }
            return builder.build();
        }
    }
}

