/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.worker;

import alluxio.stress.BaseParameters;
import alluxio.stress.Summary;
import alluxio.stress.TaskResult;
import alluxio.stress.worker.IOTaskSummary;
import alluxio.stress.worker.UfsIOParameters;
import alluxio.util.FormatUtils;
import alluxio.util.JsonSerializable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;

public class IOTaskResult
implements TaskResult {
    private List<Point> mPoints;
    private List<String> mErrors;
    private BaseParameters mBaseParameters;
    private UfsIOParameters mParameters;

    public IOTaskResult() {
        this.mPoints = new ArrayList<Point>();
        this.mErrors = new ArrayList<String>();
    }

    @JsonCreator
    public IOTaskResult(@JsonProperty(value="points") List<Point> points, @JsonProperty(value="errors") List<String> errors) {
        this.mPoints = points;
        this.mErrors = errors;
    }

    public void addPoint(Point p) {
        this.mPoints.add(p);
    }

    public List<Point> getPoints() {
        return this.mPoints;
    }

    public void addError(String errorMsg) {
        this.mErrors.add(errorMsg);
    }

    @Override
    public List<String> getErrors() {
        return this.mErrors;
    }

    public void setErrors(List<String> errors) {
        this.mErrors = errors;
    }

    public void setPoints(List<Point> points) {
        this.mPoints = points;
    }

    @Override
    public BaseParameters getBaseParameters() {
        return this.mBaseParameters;
    }

    public void setBaseParameters(BaseParameters baseParameters) {
        this.mBaseParameters = baseParameters;
    }

    public UfsIOParameters getParameters() {
        return this.mParameters;
    }

    public void setParameters(UfsIOParameters parameters) {
        this.mParameters = parameters;
    }

    public IOTaskResult merge(IOTaskResult anotherResult) {
        this.mPoints.addAll(anotherResult.getPoints());
        this.mErrors.addAll(anotherResult.getErrors());
        this.mBaseParameters = anotherResult.getBaseParameters();
        this.mParameters = anotherResult.getParameters();
        return this;
    }

    public static IOTaskResult reduceList(Iterable<IOTaskResult> results) {
        IOTaskResult aggreResult = new IOTaskResult();
        for (IOTaskResult r : results) {
            aggreResult.merge(r);
        }
        return aggreResult;
    }

    public String toString() {
        return String.format("Points=%s, Errors=%s", this.mPoints, this.mErrors);
    }

    @Override
    public TaskResult.Aggregator aggregator() {
        return new Aggregator();
    }

    public static enum IOMode {
        READ,
        WRITE;

    }

    private static final class Aggregator
    implements TaskResult.Aggregator<IOTaskResult> {
        private Aggregator() {
        }

        @Override
        public Summary aggregate(Iterable<IOTaskResult> results) throws Exception {
            return new IOTaskSummary(IOTaskResult.reduceList(results));
        }
    }

    public static class Point
    implements JsonSerializable {
        public IOMode mMode;
        public double mDurationSeconds;
        public long mDataSizeBytes;

        @JsonCreator
        public Point(@JsonProperty(value="mode") IOMode mode, @JsonProperty(value="durationSeconds") double duration, @JsonProperty(value="dataSizeBytes") long dataSize) {
            this.mMode = mode;
            this.mDurationSeconds = duration;
            this.mDataSizeBytes = dataSize;
        }

        public String toString() {
            return String.format("{mode=%s, duration=%ss, dataSize=%s}", new Object[]{this.mMode, this.mDurationSeconds, FormatUtils.getSizeFromBytes((long)this.mDataSizeBytes)});
        }

        public boolean equals(Object other) {
            if (!(other instanceof Point)) {
                return false;
            }
            Point b = (Point)other;
            return this.mMode == b.mMode && this.mDataSizeBytes == b.mDataSizeBytes && Math.abs(this.mDurationSeconds - b.mDurationSeconds) < 1.0E-5;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mMode, this.mDataSizeBytes, this.mDurationSeconds});
        }
    }
}

