/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.client;

import alluxio.collections.Pair;
import alluxio.stress.BaseParameters;
import alluxio.stress.Parameters;
import alluxio.stress.Summary;
import alluxio.stress.TaskResult;
import alluxio.stress.client.ClientIOOperation;
import alluxio.stress.client.ClientIOParameters;
import alluxio.stress.common.SummaryStatistics;
import alluxio.stress.graph.Graph;
import alluxio.stress.graph.LineGraph;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ClientIOTaskResult
implements TaskResult,
Summary {
    private long mRecordStartMs;
    private long mEndMs;
    private Map<Integer, ThreadCountResult> mThreadCountResults = new HashMap<Integer, ThreadCountResult>();
    private BaseParameters mBaseParameters;
    private ClientIOParameters mParameters;
    private Map<Integer, Map<String, SummaryStatistics>> mTimeToFirstByte = new HashMap<Integer, Map<String, SummaryStatistics>>();

    @Override
    public BaseParameters getBaseParameters() {
        return this.mBaseParameters;
    }

    public void setBaseParameters(BaseParameters baseParameters) {
        this.mBaseParameters = baseParameters;
    }

    public ClientIOParameters getParameters() {
        return this.mParameters;
    }

    public void setParameters(ClientIOParameters parameters) {
        this.mParameters = parameters;
    }

    public long getRecordStartMs() {
        return this.mRecordStartMs;
    }

    public void setRecordStartMs(long recordStartMs) {
        this.mRecordStartMs = recordStartMs;
    }

    public Map<Integer, Map<String, SummaryStatistics>> getTimeToFirstBytePerThread() {
        return this.mTimeToFirstByte;
    }

    public void setTimeToFirstBytePerThread(Map<Integer, Map<String, SummaryStatistics>> timeToFirstByte) {
        this.mTimeToFirstByte = timeToFirstByte;
    }

    public void putTimeToFirstBytePerThread(Integer numThreads, Map<String, SummaryStatistics> statistics) {
        this.mTimeToFirstByte.put(numThreads, statistics);
    }

    public long getEndMs() {
        return this.mEndMs;
    }

    public void setEndMs(long endMs) {
        this.mEndMs = endMs;
    }

    public Map<Integer, ThreadCountResult> getThreadCountResults() {
        return this.mThreadCountResults;
    }

    public void setThreadCountResults(Map<Integer, ThreadCountResult> threadCountResults) {
        this.mThreadCountResults = threadCountResults;
    }

    public void addThreadCountResults(int threadCount, ThreadCountResult threadCountResult) {
        this.mThreadCountResults.put(threadCount, threadCountResult);
    }

    private long computeLastEndMs() {
        long endMs = 0L;
        for (ThreadCountResult result : this.mThreadCountResults.values()) {
            endMs = Math.max(endMs, result.getEndMs());
        }
        return endMs;
    }

    private LineGraph.Data getThroughputData() {
        LineGraph.Data data = new LineGraph.Data();
        for (Map.Entry<Integer, ThreadCountResult> entry : this.mThreadCountResults.entrySet()) {
            data.addData(entry.getKey(), Float.valueOf(entry.getValue().getIOMBps()));
        }
        return data;
    }

    private void getNumSuccessData(String series, LineGraph lineGraph) {
        HashMap<String, LineGraph.Data> data = new HashMap<String, LineGraph.Data>();
        for (Map.Entry<Integer, Map<String, SummaryStatistics>> entry : this.mTimeToFirstByte.entrySet()) {
            for (Map.Entry<String, SummaryStatistics> methodEntry : entry.getValue().entrySet()) {
                String prefix = series + ", method: " + methodEntry.getKey();
                LineGraph.Data currentData = data.getOrDefault(prefix, new LineGraph.Data());
                currentData.addData(entry.getKey(), methodEntry.getValue().mNumSuccess);
                data.put(prefix, currentData);
            }
        }
        for (Map.Entry<Integer, Map<String, SummaryStatistics>> entry : data.entrySet()) {
            lineGraph.addDataSeries((String)((Object)entry.getKey()), (LineGraph.Data)((Object)entry.getValue()));
        }
    }

    private void getTimeToFistByteData(String series, LineGraph lineGraph) {
        for (Map.Entry<Integer, Map<String, SummaryStatistics>> threadEntry : this.mTimeToFirstByte.entrySet()) {
            for (Map.Entry<String, SummaryStatistics> methodEntry : threadEntry.getValue().entrySet()) {
                lineGraph.addDataSeries(series + ", method: " + methodEntry.getKey() + ", thread: " + threadEntry.getKey(), methodEntry.getValue().computeTimeData());
            }
        }
    }

    @Override
    public List<String> getErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        for (Map.Entry<Integer, ThreadCountResult> entry : this.mThreadCountResults.entrySet()) {
            errors.addAll(entry.getValue().getErrors().stream().map(err -> ((Integer)entry.getKey()).toString() + ": " + err).collect(Collectors.toList()));
        }
        return errors;
    }

    @Override
    public TaskResult.Aggregator aggregator() {
        return new Aggregator();
    }

    @Override
    public alluxio.stress.GraphGenerator graphGenerator() {
        return new GraphGenerator();
    }

    public static final class ThreadCountResult {
        private long mRecordStartMs;
        private long mEndMs;
        private long mIOBytes;
        private List<String> mErrors = new ArrayList<String>();

        public void merge(ThreadCountResult result) {
            this.mRecordStartMs = Math.min(this.mRecordStartMs, result.mRecordStartMs);
            this.mEndMs = Math.max(this.mEndMs, result.mEndMs);
            this.mIOBytes += result.mIOBytes;
            this.mErrors.addAll(result.mErrors);
        }

        public long getDurationMs() {
            return this.mEndMs - this.mRecordStartMs;
        }

        @JsonIgnore
        public void setDurationMs(long durationMs) {
        }

        public long getIOBytes() {
            return this.mIOBytes;
        }

        public void incrementIOBytes(long ioBytes) {
            this.mIOBytes += ioBytes;
        }

        public void setIOBytes(long ioBytes) {
            this.mIOBytes = ioBytes;
        }

        public long getRecordStartMs() {
            return this.mRecordStartMs;
        }

        public void setRecordStartMs(long recordStartMs) {
            this.mRecordStartMs = recordStartMs;
        }

        public long getEndMs() {
            return this.mEndMs;
        }

        public void setEndMs(long endMs) {
            this.mEndMs = endMs;
        }

        public List<String> getErrors() {
            return this.mErrors;
        }

        public void setErrors(List<String> errors) {
            this.mErrors = errors;
        }

        public void addErrorMessage(String errMesssage) {
            this.mErrors.add(errMesssage);
        }

        public float getIOMBps() {
            return (float)this.mIOBytes / (float)this.getDurationMs() * 1000.0f / 1048576.0f;
        }

        @JsonIgnore
        public void setIOMBps(float ioMBps) {
        }
    }

    public static final class GraphGenerator
    extends alluxio.stress.GraphGenerator {
        @Override
        public List<Graph> generate(List<? extends Summary> results) {
            ArrayList<Graph> graphs = new ArrayList<Graph>();
            List summaries = results.stream().map(x -> (ClientIOTaskResult)x).collect(Collectors.toList());
            for (ClientIOOperation operation : ClientIOOperation.values()) {
                for (Boolean readRandom : Arrays.asList(false, true)) {
                    List opSummaries = summaries.stream().filter(x -> ((ClientIOTaskResult)x).mParameters.mOperation == operation).filter(x -> ((ClientIOTaskResult)x).mParameters.mReadRandom == readRandom).collect(Collectors.toList());
                    if (opSummaries.isEmpty()) continue;
                    Pair<List<String>, List<String>> fieldNames = Parameters.partitionFieldNames(opSummaries.stream().map(x -> ((ClientIOTaskResult)x).mParameters).collect(Collectors.toList()));
                    ArrayList<String> subTitle = new ArrayList<String>(Splitter.fixedLength((int)100).splitToList((CharSequence)((ClientIOTaskResult)opSummaries.get(0)).mParameters.getDescription((List)fieldNames.getFirst())));
                    for (ClientIOTaskResult summary : opSummaries) {
                        String series = summary.mParameters.getDescription((List)fieldNames.getSecond());
                        subTitle.add(series + ": " + DateFormat.getDateTimeInstance().format(summary.computeLastEndMs()));
                    }
                    LineGraph responseTimeGraph = new LineGraph(String.format("%s - %s - Throughput", new Object[]{operation, ((ClientIOTaskResult)opSummaries.get(0)).mParameters.getDescription(Collections.singletonList("mReadRandom"))}), subTitle, "# Threads", "Throughput (MB/s)");
                    LineGraph numSuccessGraph = new LineGraph(String.format("%s - %s - API calls", new Object[]{operation, ((ClientIOTaskResult)opSummaries.get(0)).mParameters.getDescription(Collections.singletonList("mReadRandom"))}), subTitle, "# Threads", "# API calls");
                    LineGraph timeToFirstByteGraph = new LineGraph(String.format("%s - %s - Time To First Byte", new Object[]{operation, ((ClientIOTaskResult)opSummaries.get(0)).mParameters.getDescription(Collections.singletonList("mReadRandom"))}), subTitle, "# Threads", "Time To First Byte (Ms)");
                    for (ClientIOTaskResult summary : opSummaries) {
                        String series = summary.mParameters.getDescription((List)fieldNames.getSecond());
                        responseTimeGraph.addDataSeries(series, summary.getThroughputData());
                        responseTimeGraph.setErrors(series, summary.getErrors());
                        summary.getNumSuccessData(series, numSuccessGraph);
                        summary.getTimeToFistByteData(series, timeToFirstByteGraph);
                    }
                    graphs.add(responseTimeGraph);
                    graphs.add(numSuccessGraph);
                    graphs.add(timeToFirstByteGraph);
                }
            }
            return graphs;
        }
    }

    private static final class Aggregator
    implements TaskResult.Aggregator<ClientIOTaskResult> {
        private Aggregator() {
        }

        public ClientIOTaskResult aggregate(Iterable<ClientIOTaskResult> results) throws Exception {
            Iterator<ClientIOTaskResult> it = results.iterator();
            if (it.hasNext()) {
                ClientIOTaskResult taskResult = it.next();
                if (it.hasNext()) {
                    throw new IOException("ClientIO is a single node test, so multiple task results cannot be aggregated.");
                }
                return taskResult;
            }
            return new ClientIOTaskResult();
        }
    }
}

