/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.common;

import alluxio.client.ReadType;
import alluxio.client.WriteType;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.stress.Parameters;
import alluxio.stress.common.FileSystemClientType;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;

public class FileSystemParameters
extends Parameters {
    public static final String CLIENT_TYPE_OPTION_NAME = "--client-type";
    public static final String READ_TYPE_FLAG_OPTION_NAME = "--read-type";
    public static final String WRITE_TYPE_OPTION_NAME = "--write-type";
    @Parameter(names={"--client-type"}, description="the client API type. Alluxio native or hadoop compatible client, default is AlluxioHDFS", converter=FileSystemParametersClientTypeConverter.class)
    public FileSystemClientType mClientType = FileSystemClientType.ALLUXIO_HDFS;
    @Parameter(names={"--read-type"}, description="the cache mechanism during read. Options are [NO_CACHE, CACHE, CACHE_PROMOTE] default is CACHE", converter=FileSystemParametersReadTypeConverter.class)
    public ReadType mReadType = ReadType.CACHE;
    @Parameter(names={"--write-type"}, description="The write type to use when creating files. Options are [MUST_CACHE, CACHE_THROUGH, THROUGH, ASYNC_THROUGH, ALL]", converter=FileSystemParametersWriteTypeConverter.class)
    public String mWriteType = ((WriteType)Configuration.getEnum((PropertyKey)PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WriteType.class)).name();

    public static class FileSystemParametersWriteTypeConverter
    implements IStringConverter<String> {
        public String convert(String value) {
            if (value.equals("MUST_CACHE") || value.equals("CACHE_THROUGH") || value.equals("THROUGH") || value.equals("ASYNC_THROUGH") || value.equals("ALL")) {
                return value;
            }
            throw new IllegalArgumentException(String.format("%s is not a valid write type. Valid options are: MUST_CACHE, CACHE_THROUGH, THROUGH, ASYNC_THROUGH and ALL", value));
        }
    }

    public static class FileSystemParametersReadTypeConverter
    implements IStringConverter<ReadType> {
        public ReadType convert(String value) {
            return ReadType.fromString((String)value);
        }
    }

    public static class FileSystemParametersClientTypeConverter
    implements IStringConverter<FileSystemClientType> {
        public FileSystemClientType convert(String value) {
            return FileSystemClientType.fromString(value);
        }
    }
}

