/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.client;

import alluxio.stress.BaseParameters;
import alluxio.stress.Summary;
import alluxio.stress.client.ClientIOOperation;
import alluxio.stress.client.ClientIOParameters;
import alluxio.stress.client.ClientIOTaskResult;
import alluxio.stress.common.GeneralBenchSummary;
import alluxio.stress.graph.Graph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ClientIOSummary
extends GeneralBenchSummary<ClientIOTaskResult> {
    private ClientIOParameters mParameters;
    private BaseParameters mBaseParameters;
    private Map<Integer, Float> mThreadCountIoMbps;

    public ClientIOSummary() {
        this(null, null, new HashMap<String, ClientIOTaskResult>(), new HashMap<Integer, Float>());
    }

    public ClientIOSummary(ClientIOParameters parameters, BaseParameters baseParameters, Map<String, ClientIOTaskResult> nodes, Map<Integer, Float> threadCountIoMbps) {
        this.mNodeResults = nodes;
        this.mParameters = parameters;
        this.mBaseParameters = baseParameters;
        this.mThreadCountIoMbps = threadCountIoMbps;
    }

    @Override
    public GraphGenerator graphGenerator() {
        return new GraphGenerator();
    }

    public ClientIOParameters getParameters() {
        return this.mParameters;
    }

    public void setParameters(ClientIOParameters parameters) {
        this.mParameters = parameters;
    }

    public BaseParameters getBaseParameters() {
        return this.mBaseParameters;
    }

    public void setBaseParameters(BaseParameters baseParameters) {
        this.mBaseParameters = baseParameters;
    }

    public Map<Integer, Float> getThreadCountIoMbps() {
        return this.mThreadCountIoMbps;
    }

    public void setThreadCountIoMbps(Map<Integer, Float> threadCountIoMbps) {
        this.mThreadCountIoMbps = threadCountIoMbps;
    }

    public static final class GraphGenerator
    extends alluxio.stress.GraphGenerator {
        @Override
        public List<Graph> generate(List<? extends Summary> results) {
            ArrayList<Graph> graphs = new ArrayList<Graph>();
            List summaries = results.stream().map(x -> (ClientIOSummary)x).collect(Collectors.toList());
            for (ClientIOOperation operation : ClientIOOperation.values()) {
                for (Boolean readRandom : Arrays.asList(false, true)) {
                    List opSummaries = summaries.stream().filter(x -> ((ClientIOSummary)x).mParameters.mOperation == operation).filter(x -> ((ClientIOSummary)x).mParameters.mReadRandom == readRandom).collect(Collectors.toList());
                    for (ClientIOSummary summary : opSummaries) {
                        ArrayList clientResults = new ArrayList(summary.getNodeResults().values());
                        graphs.addAll(((ClientIOTaskResult)clientResults.get(0)).graphGenerator().generate(clientResults));
                    }
                }
            }
            return graphs;
        }
    }
}

