/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.master;

import alluxio.collections.Pair;
import alluxio.stress.Parameters;
import alluxio.stress.Summary;
import alluxio.stress.graph.BarGraph;
import alluxio.stress.graph.Graph;
import alluxio.stress.master.MasterBenchParameters;
import alluxio.stress.master.MasterBenchSummary;
import alluxio.stress.master.Operation;
import com.google.common.base.Splitter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class MaxThroughputSummary
implements Summary {
    private float mMaxThroughput;
    private long mEndTimeMs;
    private MasterBenchParameters mParameters;
    private Map<Long, MasterBenchSummary> mPassedRuns = new HashMap<Long, MasterBenchSummary>();
    private Map<Long, MasterBenchSummary> mFailedRuns = new HashMap<Long, MasterBenchSummary>();

    public float getMaxThroughput() {
        return this.mMaxThroughput;
    }

    public void setMaxThroughput(float maxThroughput) {
        this.mMaxThroughput = maxThroughput;
    }

    public MasterBenchParameters getParameters() {
        return this.mParameters;
    }

    public void setParameters(MasterBenchParameters parameters) {
        this.mParameters = parameters;
    }

    public long getEndTimeMs() {
        return this.mEndTimeMs;
    }

    public void setEndTimeMs(long endTimeMs) {
        this.mEndTimeMs = endTimeMs;
    }

    public void addPassedRun(long targetThroughput, MasterBenchSummary summary) {
        this.mPassedRuns.put(targetThroughput, summary);
    }

    public Map<Long, MasterBenchSummary> getPassedRuns() {
        return this.mPassedRuns;
    }

    public void setPassedRuns(Map<Long, MasterBenchSummary> passedRuns) {
        this.mPassedRuns = passedRuns;
    }

    public void addFailedRun(long targetThroughput, MasterBenchSummary summary) {
        this.mFailedRuns.put(targetThroughput, summary);
    }

    public Map<Long, MasterBenchSummary> getFailedRuns() {
        return this.mFailedRuns;
    }

    public void setFailedRuns(Map<Long, MasterBenchSummary> failedRuns) {
        this.mFailedRuns = failedRuns;
    }

    @Override
    public alluxio.stress.GraphGenerator graphGenerator() {
        return new GraphGenerator();
    }

    public static final class GraphGenerator
    extends alluxio.stress.GraphGenerator {
        @Override
        public List<Graph> generate(List<? extends Summary> results) {
            ArrayList<Graph> graphs = new ArrayList<Graph>();
            List summaries = results.stream().map(x -> (MaxThroughputSummary)x).collect(Collectors.toList());
            for (Operation operation : Operation.values()) {
                String series;
                List opSummaries = summaries.stream().filter(x -> ((MaxThroughputSummary)x).mParameters.mOperation == operation).collect(Collectors.toList());
                if (opSummaries.isEmpty()) continue;
                Pair<List<String>, List<String>> fieldNames = Parameters.partitionFieldNames(opSummaries.stream().map(x -> ((MaxThroughputSummary)x).mParameters).collect(Collectors.toList()));
                ArrayList<String> subTitle = new ArrayList<String>(Splitter.fixedLength((int)100).splitToList((CharSequence)((MaxThroughputSummary)opSummaries.get(0)).mParameters.getDescription((List)fieldNames.getFirst())));
                for (MaxThroughputSummary summary : opSummaries) {
                    String series2 = summary.mParameters.getDescription((List)fieldNames.getSecond());
                    subTitle.add(series2 + ": " + DateFormat.getDateTimeInstance().format(summary.getEndTimeMs()));
                }
                BarGraph maxGraph = new BarGraph((Object)((Object)operation) + " - Max Throughput", subTitle, "Throughput");
                for (MaxThroughputSummary summary : opSummaries) {
                    series = summary.mParameters.getDescription((List)fieldNames.getSecond());
                    BarGraph.Data data = new BarGraph.Data();
                    data.addData(Float.valueOf(summary.getMaxThroughput()));
                    maxGraph.addDataSeries(series, data);
                }
                graphs.add(maxGraph);
                for (MaxThroughputSummary summary : opSummaries) {
                    series = summary.mParameters.getDescription((List)fieldNames.getSecond());
                    ArrayList<MasterBenchSummary> runs = new ArrayList<MasterBenchSummary>(summary.getPassedRuns().values());
                    alluxio.stress.GraphGenerator runGraphGenerator = ((MasterBenchSummary)runs.get(0)).graphGenerator();
                    List<Graph> runGraphs = runGraphGenerator.generate(runs);
                    for (Graph graph : runGraphs) {
                        ArrayList<String> newTitle = new ArrayList<String>();
                        newTitle.add(series);
                        newTitle.addAll(graph.getTitle());
                        graph.setTitle(newTitle);
                    }
                    graphs.addAll(runGraphs);
                }
            }
            return graphs;
        }
    }
}

