/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.master;

import alluxio.stress.TaskResult;
import alluxio.stress.master.MasterBenchParameters;
import alluxio.stress.master.MasterBenchSummary;
import alluxio.stress.master.MasterBenchTaskResultBase;
import alluxio.stress.master.MasterBenchTaskResultStatistics;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;

public final class MasterBenchTaskResult
extends MasterBenchTaskResultBase<MasterBenchParameters> {
    private MasterBenchTaskResultStatistics mStatistics = new MasterBenchTaskResultStatistics();
    private Map<String, MasterBenchTaskResultStatistics> mStatisticsPerMethod = new HashMap<String, MasterBenchTaskResultStatistics>();

    @Override
    void mergeResultStatistics(MasterBenchTaskResultBase<MasterBenchParameters> result) throws Exception {
        Preconditions.checkState((boolean)(result instanceof MasterBenchTaskResult));
        MasterBenchTaskResult convertedResult = (MasterBenchTaskResult)result;
        this.mStatistics.merge(convertedResult.mStatistics);
        for (Map.Entry<String, MasterBenchTaskResultStatistics> entry : convertedResult.mStatisticsPerMethod.entrySet()) {
            String key = entry.getKey();
            MasterBenchTaskResultStatistics value = entry.getValue();
            if (!this.mStatisticsPerMethod.containsKey(key)) {
                this.mStatisticsPerMethod.put(key, value);
                continue;
            }
            this.mStatisticsPerMethod.get(key).merge(value);
        }
    }

    public void incrementNumSuccess(long numSuccess) {
        this.mStatistics.mNumSuccess += numSuccess;
    }

    public MasterBenchTaskResultStatistics getStatistics() {
        return this.mStatistics;
    }

    public void setStatistics(MasterBenchTaskResultStatistics statistics) {
        this.mStatistics = statistics;
    }

    public Map<String, MasterBenchTaskResultStatistics> getStatisticsPerMethod() {
        return this.mStatisticsPerMethod;
    }

    public void setStatisticsPerMethod(Map<String, MasterBenchTaskResultStatistics> statisticsPerMethod) {
        this.mStatisticsPerMethod = statisticsPerMethod;
    }

    @Override
    public void putStatisticsForMethod(String method, MasterBenchTaskResultStatistics statistics) {
        this.mStatisticsPerMethod.put(method, statistics);
    }

    @Override
    public TaskResult.Aggregator aggregator() {
        return new Aggregator();
    }

    private static final class Aggregator
    implements TaskResult.Aggregator<MasterBenchTaskResult> {
        private Aggregator() {
        }

        public MasterBenchSummary aggregate(Iterable<MasterBenchTaskResult> results) throws Exception {
            HashMap<String, MasterBenchTaskResult> nodes = new HashMap<String, MasterBenchTaskResult>();
            MasterBenchTaskResult mergingTaskResult = null;
            for (MasterBenchTaskResult taskResult : results) {
                nodes.put(taskResult.getBaseParameters().mId, taskResult);
                if (mergingTaskResult == null) {
                    mergingTaskResult = taskResult;
                    continue;
                }
                mergingTaskResult.aggregateByWorker(taskResult);
            }
            return new MasterBenchSummary(mergingTaskResult, nodes);
        }
    }
}

