/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.master;

import alluxio.stress.TaskResult;
import alluxio.stress.master.MasterBenchTaskResultBase;
import alluxio.stress.master.MasterBenchTaskResultStatistics;
import alluxio.stress.master.MultiOperationMasterBenchParameters;
import alluxio.stress.master.MultiOperationMasterBenchSummary;
import alluxio.stress.master.Operation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MultiOperationMasterBenchTaskResult
extends MasterBenchTaskResultBase<MultiOperationMasterBenchParameters> {
    private final List<MasterBenchTaskResultStatistics> mStatistics;
    private final Map<String, MasterBenchTaskResultStatistics> mStatisticsPerMethod = new HashMap<String, MasterBenchTaskResultStatistics>();

    public MultiOperationMasterBenchTaskResult(Operation[] operations) {
        this.mStatistics = new ArrayList<MasterBenchTaskResultStatistics>();
        for (int i = 0; i < operations.length; ++i) {
            this.mStatistics.add(new MasterBenchTaskResultStatistics(operations[i]));
        }
    }

    public MultiOperationMasterBenchTaskResult() {
        this.mStatistics = new ArrayList<MasterBenchTaskResultStatistics>();
    }

    @Override
    void mergeResultStatistics(MasterBenchTaskResultBase<MultiOperationMasterBenchParameters> result) throws Exception {
        Preconditions.checkState((boolean)(result instanceof MultiOperationMasterBenchTaskResult));
        MultiOperationMasterBenchTaskResult convertedResult = (MultiOperationMasterBenchTaskResult)result;
        for (int i = 0; i < this.mStatistics.size(); ++i) {
            this.mStatistics.get(i).merge(convertedResult.mStatistics.get(i));
        }
        for (Map.Entry<String, MasterBenchTaskResultStatistics> entry : convertedResult.mStatisticsPerMethod.entrySet()) {
            String key = entry.getKey();
            MasterBenchTaskResultStatistics value = entry.getValue();
            if (!this.mStatisticsPerMethod.containsKey(key)) {
                this.mStatisticsPerMethod.put(key, value);
                continue;
            }
            this.mStatisticsPerMethod.get(key).merge(value);
        }
    }

    public void incrementNumSuccess(int operationIndex, long numSuccess) {
        this.mStatistics.get((int)operationIndex).mNumSuccesses += numSuccess;
    }

    public MasterBenchTaskResultStatistics getStatistics(int operationIndex) {
        return this.mStatistics.get(operationIndex);
    }

    public List<MasterBenchTaskResultStatistics> getAllStatistics() {
        return this.mStatistics;
    }

    public Map<String, MasterBenchTaskResultStatistics> getStatisticsPerMethod() {
        return this.mStatisticsPerMethod;
    }

    @Override
    public void putStatisticsForMethod(String method, MasterBenchTaskResultStatistics statistics) {
        this.mStatisticsPerMethod.put(method, statistics);
    }

    @Override
    public Aggregator aggregator() {
        return new Aggregator();
    }

    @JsonIgnore
    public long getNumSuccessOperations() {
        long throughput = 0L;
        for (MasterBenchTaskResultStatistics statistic : this.mStatistics) {
            throughput += statistic.mNumSuccesses;
        }
        return throughput;
    }

    private static final class Aggregator
    implements TaskResult.Aggregator<MultiOperationMasterBenchTaskResult> {
        private Aggregator() {
        }

        public MultiOperationMasterBenchSummary aggregate(Iterable<MultiOperationMasterBenchTaskResult> results) throws Exception {
            HashMap<String, MultiOperationMasterBenchTaskResult> nodes = new HashMap<String, MultiOperationMasterBenchTaskResult>();
            MultiOperationMasterBenchTaskResult mergingTaskResult = null;
            for (MultiOperationMasterBenchTaskResult taskResult : results) {
                nodes.put(taskResult.getBaseParameters().mId, taskResult);
                if (mergingTaskResult == null) {
                    mergingTaskResult = taskResult;
                    continue;
                }
                mergingTaskResult.aggregateByWorker(taskResult);
            }
            return new MultiOperationMasterBenchSummary(mergingTaskResult, nodes);
        }
    }
}

