/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.worker;

import alluxio.stress.BaseParameters;
import alluxio.stress.TaskResult;
import alluxio.stress.worker.WorkerBenchCoarseDataPoint;
import alluxio.stress.worker.WorkerBenchParameters;
import alluxio.stress.worker.WorkerBenchSummary;
import alluxio.util.FormatUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.HdrHistogram.Histogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkerBenchTaskResult
implements TaskResult {
    private static final Logger LOG = LoggerFactory.getLogger(WorkerBenchTaskResult.class);
    private BaseParameters mBaseParameters;
    private WorkerBenchParameters mParameters;
    private long mRecordStartMs;
    private long mEndMs;
    private long mIOBytes;
    private List<String> mErrors = new ArrayList<String>();
    private final List<WorkerBenchCoarseDataPoint> mDataPoints = new ArrayList<WorkerBenchCoarseDataPoint>();
    private List<Long> mAllThroughputValues = new ArrayList<Long>();
    private List<Long> mThroughputPercentiles = new ArrayList<Long>();

    public void merge(WorkerBenchTaskResult result) throws Exception {
        this.mErrors.addAll(result.mErrors);
        if (this.mAllThroughputValues.isEmpty()) {
            for (WorkerBenchCoarseDataPoint dataPoint : this.mDataPoints) {
                this.mAllThroughputValues.addAll(new ArrayList<Long>(dataPoint.getThroughput()));
                dataPoint.clearThroughput();
            }
        }
        if (result.mAllThroughputValues.isEmpty()) {
            for (WorkerBenchCoarseDataPoint dataPoint : result.mDataPoints) {
                this.mAllThroughputValues.addAll(new ArrayList<Long>(dataPoint.getThroughput()));
                dataPoint.clearThroughput();
            }
        } else {
            this.mAllThroughputValues.addAll(result.mAllThroughputValues);
        }
        this.mDataPoints.addAll(result.mDataPoints);
        this.aggregateByWorker(result);
    }

    public void aggregateByWorker(WorkerBenchTaskResult result) {
        this.mBaseParameters = result.mBaseParameters;
        this.mParameters = result.mParameters;
        this.mRecordStartMs = result.mRecordStartMs;
        this.mEndMs = Math.max(this.mEndMs, result.mEndMs);
        this.mIOBytes += result.mIOBytes;
    }

    public long getIOBytes() {
        return this.mIOBytes;
    }

    public void incrementIOBytes(long ioBytes) {
        this.mIOBytes += ioBytes;
    }

    public void setIOBytes(long ioBytes) {
        this.mIOBytes = ioBytes;
    }

    @Override
    public BaseParameters getBaseParameters() {
        return this.mBaseParameters;
    }

    public void setBaseParameters(BaseParameters baseParameters) {
        this.mBaseParameters = baseParameters;
    }

    public WorkerBenchParameters getParameters() {
        return this.mParameters;
    }

    public void setParameters(WorkerBenchParameters parameters) {
        this.mParameters = parameters;
    }

    public long getRecordStartMs() {
        return this.mRecordStartMs;
    }

    public void setRecordStartMs(long recordStartMs) {
        this.mRecordStartMs = recordStartMs;
    }

    public long getEndMs() {
        return this.mEndMs;
    }

    public void setEndMs(long endMs) {
        this.mEndMs = endMs;
    }

    @Override
    public List<String> getErrors() {
        return this.mErrors;
    }

    public void setErrors(List<String> errors) {
        this.mErrors = errors;
    }

    public List<Long> getThroughputPercentiles() {
        return this.mThroughputPercentiles;
    }

    public void setThroughputPercentiles(List<Long> percentiles) {
        this.mThroughputPercentiles = percentiles;
    }

    public List<Long> getAllThroughput() {
        return this.mAllThroughputValues;
    }

    public void setAllThroughput(List<Long> allThroughputValues) {
        this.mAllThroughputValues = allThroughputValues;
    }

    public void calculatePercentiles() {
        Histogram throughputHistogram = new Histogram(FormatUtils.parseSpaceSize((String)this.mParameters.mFileSize), 3);
        this.mAllThroughputValues.forEach(arg_0 -> ((Histogram)throughputHistogram).recordValue(arg_0));
        for (int i = 0; i <= 100; ++i) {
            this.mThroughputPercentiles.add(throughputHistogram.getValueAtPercentile((double)i));
        }
    }

    public void addErrorMessage(String errMessage) {
        this.mErrors.add(errMessage);
    }

    public List<WorkerBenchCoarseDataPoint> getDataPoints() {
        return this.mDataPoints;
    }

    public void addDataPoint(WorkerBenchCoarseDataPoint point) {
        this.mDataPoints.add(point);
    }

    public void addDataPoints(Collection<WorkerBenchCoarseDataPoint> stats) {
        this.mDataPoints.addAll(stats);
    }

    public void clearAllThroughput() {
        this.mAllThroughputValues.clear();
    }

    @Override
    public TaskResult.Aggregator aggregator() {
        return new Aggregator();
    }

    private static final class Aggregator
    implements TaskResult.Aggregator<WorkerBenchTaskResult> {
        private Aggregator() {
        }

        public WorkerBenchSummary aggregate(Iterable<WorkerBenchTaskResult> results) throws Exception {
            HashMap<String, WorkerBenchTaskResult> nodeResults = new HashMap<String, WorkerBenchTaskResult>();
            WorkerBenchTaskResult mergedTaskResult = new WorkerBenchTaskResult();
            for (WorkerBenchTaskResult result : results) {
                result.calculatePercentiles();
                mergedTaskResult.merge(result);
                result.clearAllThroughput();
                LOG.info("Test results from worker {} has been merged.Individual data points are now cleared from output.", (Object)result.getBaseParameters().mId);
                nodeResults.put(result.getBaseParameters().mId, result);
            }
            return new WorkerBenchSummary(mergedTaskResult, nodeResults);
        }
    }
}

