/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli;

import alluxio.stress.cli.Benchmark;
import alluxio.stress.rpc.RpcBenchParameters;
import alluxio.stress.rpc.RpcTaskResult;
import alluxio.util.executor.ExecutorServiceFactories;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcBench<T extends RpcBenchParameters>
extends Benchmark<RpcTaskResult> {
    private static final Logger LOG = LoggerFactory.getLogger(RpcBench.class);
    protected ExecutorService mPool = null;

    public abstract RpcTaskResult runRPC() throws Exception;

    public abstract T getParameters();

    public ExecutorService getPool() {
        if (this.mPool == null) {
            this.mPool = ExecutorServiceFactories.fixedThreadPool((String)"rpc-thread", (int)((RpcBenchParameters)this.getParameters()).mConcurrency).create();
        }
        return this.mPool;
    }

    @Override
    public void cleanup() throws Exception {
        if (this.mPool != null) {
            LOG.debug("Terminating thread pool");
            this.mPool.shutdownNow();
            this.mPool.awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    @Override
    public RpcTaskResult runLocal() throws Exception {
        T rpcBenchParameters = this.getParameters();
        LOG.info("Running locally with {} threads", (Object)((RpcBenchParameters)rpcBenchParameters).mConcurrency);
        ArrayList<CompletableFuture<RpcTaskResult>> futures = new ArrayList<CompletableFuture<RpcTaskResult>>();
        try {
            for (int i = 0; i < ((RpcBenchParameters)rpcBenchParameters).mConcurrency; ++i) {
                CompletableFuture<RpcTaskResult> future = CompletableFuture.supplyAsync(() -> {
                    RpcTaskResult threadResult = new RpcTaskResult();
                    threadResult.setBaseParameters(this.mBaseParameters);
                    threadResult.setParameters(rpcBenchParameters);
                    try {
                        RpcTaskResult r = this.runRPC();
                        threadResult.merge(r);
                        return threadResult;
                    }
                    catch (Exception e) {
                        LOG.error("Failed to execute RPC", (Throwable)e);
                        threadResult.addError(e.getMessage());
                        return threadResult;
                    }
                }, this.getPool());
                futures.add(future);
            }
            LOG.info("{} jobs submitted", (Object)futures.size());
            RpcTaskResult merged = futures.stream().map(CompletableFuture::join).reduce(new RpcTaskResult(this.mBaseParameters, rpcBenchParameters), (sum, one) -> {
                sum.merge(one);
                return sum;
            });
            return merged;
        }
        catch (Exception e) {
            LOG.error("Failed to execute RPC in pool", (Throwable)e);
            RpcTaskResult result = new RpcTaskResult();
            result.setBaseParameters(this.mBaseParameters);
            result.setParameters(rpcBenchParameters);
            result.addError(e.getMessage());
            return result;
        }
    }
}

