/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli.client;

import alluxio.AlluxioURI;
import alluxio.annotation.SuppressFBWarnings;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.Source;
import alluxio.exception.AlluxioException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.hadoop.HadoopConfigurationUtils;
import alluxio.stress.cli.Benchmark;
import alluxio.stress.cli.client.ClientIOWritePolicy;
import alluxio.stress.client.ClientIOOperation;
import alluxio.stress.client.ClientIOParameters;
import alluxio.stress.client.ClientIOTaskResult;
import alluxio.stress.common.FileSystemClientType;
import alluxio.stress.common.SummaryStatistics;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.FormatUtils;
import alluxio.util.executor.ExecutorServiceFactories;
import com.beust.jcommander.ParametersDelegate;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StressClientIOBench
extends Benchmark<ClientIOTaskResult> {
    private static final Logger LOG = LoggerFactory.getLogger(StressClientIOBench.class);
    @ParametersDelegate
    private ClientIOParameters mParameters = new ClientIOParameters();
    private FileSystem[] mCachedFs;
    private alluxio.client.file.FileSystem[] mCachedNativeFs;
    private volatile boolean mStartBarrierPassed = false;

    public static void main(String[] args) {
        StressClientIOBench.mainInternal(args, new StressClientIOBench());
    }

    @Override
    public String getBenchDescription() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void prepare() throws Exception {
        Configuration hdfsConf;
        if (this.mBaseParameters.mCluster && this.mBaseParameters.mClusterLimit != 1) {
            throw new IllegalArgumentException(String.format("%s is a single-node client IO stress test, so it cannot be run in cluster mode without flag '%s 1'.", this.getClass().getName(), "--cluster-limit"));
        }
        if (FormatUtils.parseSpaceSize((String)this.mParameters.mFileSize) < FormatUtils.parseSpaceSize((String)this.mParameters.mBufferSize)) {
            throw new IllegalArgumentException(String.format("File size (%s) must be larger than buffer size (%s)", this.mParameters.mFileSize, this.mParameters.mBufferSize));
        }
        if (this.mParameters.mOperation == ClientIOOperation.WRITE) {
            LOG.warn("Cannot write repeatedly, so warmup is not possible. Setting warmup to 0s.");
            this.mParameters.mWarmup = "0s";
        }
        if (!this.mBaseParameters.mDistributed) {
            hdfsConf = new Configuration();
            hdfsConf.set("alluxio.user.file.delete.unchecked", "true");
            hdfsConf.set("alluxio.user.file.writetype.default", "MUST_CACHE");
            FileSystem prepareFs = FileSystem.get((URI)new URI(this.mParameters.mBasePath), (Configuration)hdfsConf);
            Path path = new Path(this.mParameters.mBasePath);
            if (!ClientIOOperation.isRead((ClientIOOperation)this.mParameters.mOperation)) {
                prepareFs.delete(path, true);
                prepareFs.mkdirs(path);
            }
        }
        ClientIOWritePolicy.setMaxWorkers(this.mParameters.mWriteNumWorkers);
        hdfsConf = new Configuration();
        hdfsConf.set(String.format("fs.%s.impl.disable.cache", new URI(this.mParameters.mBasePath).getScheme()), "true");
        hdfsConf.set("alluxio.user.block.write.location.policy.class", ClientIOWritePolicy.class.getName());
        for (Map.Entry entry : this.mParameters.mConf.entrySet()) {
            hdfsConf.set((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.mParameters.mClientType == FileSystemClientType.ALLUXIO_HDFS) {
            LOG.info("Using ALLUXIO HDFS Compatible API to perform the test.");
            this.mCachedFs = new FileSystem[this.mParameters.mClients];
            for (int i = 0; i < this.mCachedFs.length; ++i) {
                this.mCachedFs[i] = FileSystem.get((URI)new URI(this.mParameters.mBasePath), (Configuration)hdfsConf);
            }
        } else {
            void var3_8;
            LOG.info("Using ALLUXIO Native API to perform the test.");
            AlluxioProperties alluxioProperties = ConfigurationUtils.defaults();
            alluxioProperties.merge(HadoopConfigurationUtils.getConfigurationFromHadoop((Configuration)hdfsConf), Source.RUNTIME);
            this.mCachedNativeFs = new alluxio.client.file.FileSystem[this.mParameters.mClients];
            boolean bl = false;
            while (var3_8 < this.mCachedNativeFs.length) {
                this.mCachedNativeFs[var3_8] = FileSystem.Factory.create((AlluxioConfiguration)new InstancedConfiguration(alluxioProperties));
                ++var3_8;
            }
        }
    }

    @Override
    public ClientIOTaskResult runLocal() throws Exception {
        ArrayList<Integer> threadCounts = new ArrayList<Integer>(this.mParameters.mThreads);
        threadCounts.sort(Comparator.comparingInt(i -> i));
        ClientIOTaskResult taskResult = new ClientIOTaskResult();
        taskResult.setBaseParameters(this.mBaseParameters);
        taskResult.setParameters(this.mParameters);
        for (Integer numThreads : threadCounts) {
            ClientIOTaskResult.ThreadCountResult threadCountResult = this.runForThreadCount(numThreads);
            if (!this.mBaseParameters.mProfileAgent.isEmpty()) {
                taskResult.putTimeToFirstBytePerThread(numThreads, this.addAdditionalResult(threadCountResult.getRecordStartMs(), threadCountResult.getEndMs()));
            }
            taskResult.addThreadCountResults(numThreads.intValue(), threadCountResult);
        }
        return taskResult;
    }

    private BenchThread getBenchThread(BenchContext context, int index) {
        if (this.mParameters.mClientType == FileSystemClientType.ALLUXIO_HDFS) {
            return new AlluxioHDFSBenchThread(context, this.mCachedFs[index % this.mCachedFs.length], index);
        }
        return new AlluxioNativeBenchThread(context, this.mCachedNativeFs[index % this.mCachedNativeFs.length], index);
    }

    private ClientIOTaskResult.ThreadCountResult runForThreadCount(int numThreads) throws Exception {
        LOG.info("Running benchmark for thread count: " + numThreads);
        ExecutorService service = ExecutorServiceFactories.fixedThreadPool((String)"bench-thread", (int)numThreads).create();
        long durationMs = FormatUtils.parseTimeSize((String)this.mParameters.mDuration);
        long warmupMs = FormatUtils.parseTimeSize((String)this.mParameters.mWarmup);
        long startMs = this.mBaseParameters.mStartMs;
        if (startMs == -1L || this.mStartBarrierPassed) {
            startMs = CommonUtils.getCurrentMs() + 10000L;
        }
        long endMs = startMs + warmupMs + durationMs;
        BenchContext context = new BenchContext(startMs, endMs);
        ArrayList<BenchThread> callables = new ArrayList<BenchThread>(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            callables.add(this.getBenchThread(context, i));
        }
        service.invokeAll(callables, FormatUtils.parseTimeSize((String)this.mBaseParameters.mBenchTimeout), TimeUnit.MILLISECONDS);
        service.shutdownNow();
        service.awaitTermination(30L, TimeUnit.SECONDS);
        ClientIOTaskResult.ThreadCountResult result = context.getResult();
        LOG.info(String.format("thread count: %d, errors: %d, IO throughput (MB/s): %f", numThreads, result.getErrors().size(), Float.valueOf(result.getIOMBps())));
        return result;
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    public synchronized Map<String, SummaryStatistics> addAdditionalResult(long startMs, long endMs) throws IOException {
        HashMap<String, SummaryStatistics> summaryStatistics = new HashMap<String, SummaryStatistics>();
        Map<String, Benchmark.MethodStatistics> nameStatistics = this.processMethodProfiles(startMs, endMs, profileInput -> {
            if (profileInput.getIsttfb()) {
                return profileInput.getMethod();
            }
            return null;
        });
        if (!nameStatistics.isEmpty()) {
            for (Map.Entry<String, Benchmark.MethodStatistics> entry : nameStatistics.entrySet()) {
                summaryStatistics.put(entry.getKey(), this.toSummaryStatistics(entry.getValue()));
            }
        }
        return summaryStatistics;
    }

    private SummaryStatistics toSummaryStatistics(Benchmark.MethodStatistics methodStatistics) {
        float[] responseTimePercentile = new float[101];
        for (int i = 0; i <= 100; ++i) {
            responseTimePercentile[i] = (float)methodStatistics.getTimeNs().getValueAtPercentile((double)i) / 1000000.0f;
        }
        float[] responseTime99Percentile = new float[6];
        for (int i = 0; i < responseTime99Percentile.length; ++i) {
            responseTime99Percentile[i] = (float)methodStatistics.getTimeNs().getValueAtPercentile(100.0 - 1.0 / Math.pow(10.0, i)) / 1000000.0f;
        }
        float[] maxResponseTimesMs = new float[20];
        Arrays.fill(maxResponseTimesMs, -1.0f);
        for (int i = 0; i < methodStatistics.getMaxTimeNs().length; ++i) {
            maxResponseTimesMs[i] = (float)methodStatistics.getMaxTimeNs()[i] / 1000000.0f;
        }
        return new SummaryStatistics((long)methodStatistics.getNumSuccess(), responseTimePercentile, responseTime99Percentile, maxResponseTimesMs);
    }

    private final class AlluxioNativeBenchThread
    extends BenchThread {
        private final alluxio.client.file.FileSystem mFs;
        private FileInStream mInStream;
        private FileOutStream mOutStream;

        private AlluxioNativeBenchThread(BenchContext context, alluxio.client.file.FileSystem fs, int threadId) {
            super(context, threadId);
            this.mInStream = null;
            this.mOutStream = null;
            this.mFs = fs;
        }

        @Override
        protected int applyOperation() throws IOException, AlluxioException {
            if (ClientIOOperation.isRead((ClientIOOperation)((StressClientIOBench)StressClientIOBench.this).mParameters.mOperation)) {
                if (this.mInStream == null) {
                    this.mInStream = this.mFs.openFile(new AlluxioURI(this.mFilePath.toString()));
                }
                if (((StressClientIOBench)StressClientIOBench.this).mParameters.mReadRandom) {
                    this.mCurrentOffset = (Long)this.mLongs.next();
                    if (!ClientIOOperation.isPosRead((ClientIOOperation)((StressClientIOBench)StressClientIOBench.this).mParameters.mOperation)) {
                        this.mInStream.seek(this.mCurrentOffset);
                    }
                } else {
                    this.mCurrentOffset += (long)this.mBuffer.length;
                    if (this.mCurrentOffset > this.mMaxOffset) {
                        this.mCurrentOffset = 0L;
                    }
                }
            }
            switch (((StressClientIOBench)StressClientIOBench.this).mParameters.mOperation) {
                case READ_ARRAY: {
                    int bytesRead = this.mInStream.read(this.mBuffer);
                    if (bytesRead < 0) {
                        this.closeInStream();
                        this.mInStream = this.mFs.openFile(new AlluxioURI(this.mFilePath.toString()));
                    }
                    return bytesRead;
                }
                case READ_BYTE_BUFFER: {
                    int bytesRead = this.mInStream.read(this.mByteBuffer);
                    this.mByteBuffer.reset();
                    if (bytesRead < 0) {
                        this.closeInStream();
                        this.mInStream = this.mFs.openFile(new AlluxioURI(this.mFilePath.toString()));
                    }
                    return bytesRead;
                }
                case READ_FULLY: 
                case POS_READ_FULLY: {
                    throw new UnsupportedOperationException("READ_FULLY and POS_READ_FULLY are not supported!");
                }
                case POS_READ: {
                    return this.mInStream.positionedRead(this.mCurrentOffset, this.mBuffer, 0, this.mBuffer.length);
                }
                case WRITE: {
                    int bytesToWrite;
                    if (this.mOutStream == null) {
                        this.mOutStream = this.mFs.createFile(new AlluxioURI(this.mFilePath.toString()), CreateFilePOptions.newBuilder().setBlockSizeBytes(this.mBlockSize).setRecursive(true).build());
                    }
                    if ((bytesToWrite = (int)Math.min(this.mFileSize - this.mOutStream.getBytesWritten(), (long)this.mBuffer.length)) == 0) {
                        this.mOutStream.close();
                        return -1;
                    }
                    this.mOutStream.write(this.mBuffer, 0, bytesToWrite);
                    return bytesToWrite;
                }
            }
            throw new IllegalStateException("Unknown operation: " + ((StressClientIOBench)StressClientIOBench.this).mParameters.mOperation);
        }

        @Override
        protected void closeInStream() {
            try {
                if (this.mInStream != null) {
                    this.mInStream.close();
                }
            }
            catch (IOException e) {
                this.mThreadCountResult.addErrorMessage(e.getMessage());
            }
            finally {
                this.mInStream = null;
            }
        }
    }

    private final class AlluxioHDFSBenchThread
    extends BenchThread {
        private final FileSystem mFs;
        private FSDataInputStream mInStream;
        private FSDataOutputStream mOutStream;
        private long mCurrentOffset;

        private AlluxioHDFSBenchThread(BenchContext context, FileSystem fs, int threadId) {
            super(context, threadId);
            this.mInStream = null;
            this.mOutStream = null;
            this.mFs = fs;
        }

        @Override
        protected int applyOperation() throws IOException {
            if (ClientIOOperation.isRead((ClientIOOperation)((StressClientIOBench)StressClientIOBench.this).mParameters.mOperation)) {
                if (this.mInStream == null) {
                    this.mInStream = this.mFs.open(this.mFilePath);
                }
                if (((StressClientIOBench)StressClientIOBench.this).mParameters.mReadRandom) {
                    this.mCurrentOffset = (Long)this.mLongs.next();
                    if (!ClientIOOperation.isPosRead((ClientIOOperation)((StressClientIOBench)StressClientIOBench.this).mParameters.mOperation)) {
                        this.mInStream.seek(this.mCurrentOffset);
                    }
                } else {
                    this.mCurrentOffset += (long)this.mBuffer.length;
                    if (this.mCurrentOffset > this.mMaxOffset) {
                        this.mCurrentOffset = 0L;
                    }
                }
            }
            switch (((StressClientIOBench)StressClientIOBench.this).mParameters.mOperation) {
                case READ_ARRAY: {
                    int bytesRead = this.mInStream.read(this.mBuffer);
                    if (bytesRead < 0) {
                        this.closeInStream();
                        this.mInStream = this.mFs.open(this.mFilePath);
                    }
                    return bytesRead;
                }
                case READ_BYTE_BUFFER: {
                    int bytesRead = this.mInStream.read(this.mByteBuffer);
                    this.mByteBuffer.reset();
                    if (bytesRead < 0) {
                        this.closeInStream();
                        this.mInStream = this.mFs.open(this.mFilePath);
                    }
                    return bytesRead;
                }
                case READ_FULLY: {
                    int toRead = Math.min(this.mBuffer.length, (int)(this.mFileSize - this.mInStream.getPos()));
                    this.mInStream.readFully(this.mBuffer, 0, toRead);
                    if (this.mInStream.getPos() == this.mFileSize) {
                        this.closeInStream();
                        this.mInStream = this.mFs.open(this.mFilePath);
                    }
                    return toRead;
                }
                case POS_READ: {
                    return this.mInStream.read(this.mCurrentOffset, this.mBuffer, 0, this.mBuffer.length);
                }
                case POS_READ_FULLY: {
                    this.mInStream.readFully(this.mCurrentOffset, this.mBuffer, 0, this.mBuffer.length);
                    return this.mBuffer.length;
                }
                case WRITE: {
                    int bytesToWrite;
                    if (this.mOutStream == null) {
                        this.mOutStream = this.mFs.create(this.mFilePath, false, this.mBuffer.length, (short)1, this.mBlockSize);
                    }
                    if ((bytesToWrite = (int)Math.min(this.mFileSize - this.mOutStream.getPos(), (long)this.mBuffer.length)) == 0) {
                        this.mOutStream.close();
                        return -1;
                    }
                    this.mOutStream.write(this.mBuffer, 0, bytesToWrite);
                    return bytesToWrite;
                }
            }
            throw new IllegalStateException("Unknown operation: " + ((StressClientIOBench)StressClientIOBench.this).mParameters.mOperation);
        }

        @Override
        protected void closeInStream() {
            try {
                if (this.mInStream != null) {
                    this.mInStream.close();
                }
            }
            catch (IOException e) {
                this.mThreadCountResult.addErrorMessage(e.getMessage());
            }
            finally {
                this.mInStream = null;
            }
        }
    }

    private abstract class BenchThread
    implements Callable<Void> {
        private final BenchContext mContext;
        protected final Path mFilePath;
        protected final byte[] mBuffer;
        protected final ByteBuffer mByteBuffer;
        protected final int mThreadId;
        protected final long mFileSize;
        protected final long mMaxOffset;
        protected final Iterator<Long> mLongs;
        protected final long mBlockSize;
        protected final ClientIOTaskResult.ThreadCountResult mThreadCountResult = new ClientIOTaskResult.ThreadCountResult();
        protected long mCurrentOffset;

        protected BenchThread(BenchContext context, int threadId) {
            this.mContext = context;
            int fileId = this.mThreadId = threadId;
            if (((StressClientIOBench)StressClientIOBench.this).mParameters.mReadSameFile) {
                fileId = 0;
            }
            this.mFilePath = new Path(((StressClientIOBench)StressClientIOBench.this).mParameters.mBasePath, "data-" + fileId);
            this.mBuffer = new byte[(int)FormatUtils.parseSpaceSize((String)((StressClientIOBench)StressClientIOBench.this).mParameters.mBufferSize)];
            Arrays.fill(this.mBuffer, (byte)65);
            this.mByteBuffer = ByteBuffer.wrap(this.mBuffer);
            this.mByteBuffer.mark();
            this.mCurrentOffset = this.mFileSize = FormatUtils.parseSpaceSize((String)((StressClientIOBench)StressClientIOBench.this).mParameters.mFileSize);
            this.mMaxOffset = this.mFileSize - (long)this.mBuffer.length;
            this.mBlockSize = FormatUtils.parseSpaceSize((String)((StressClientIOBench)StressClientIOBench.this).mParameters.mBlockSize);
            this.mLongs = new Random().longs(0L, this.mMaxOffset).iterator();
        }

        @Override
        public Void call() {
            try {
                this.runInternal();
            }
            catch (Exception e) {
                LOG.error(Thread.currentThread().getName() + ": failed", (Throwable)e);
                this.mThreadCountResult.addErrorMessage(e.getMessage());
            }
            finally {
                this.closeInStream();
            }
            this.mThreadCountResult.setEndMs(CommonUtils.getCurrentMs());
            this.mContext.mergeThreadResult(this.mThreadCountResult);
            return null;
        }

        private void runInternal() throws Exception {
            long recordMs = this.mContext.getStartMs() + FormatUtils.parseTimeSize((String)((StressClientIOBench)StressClientIOBench.this).mParameters.mWarmup);
            this.mThreadCountResult.setRecordStartMs(recordMs);
            boolean isRead = ClientIOOperation.isRead((ClientIOOperation)((StressClientIOBench)StressClientIOBench.this).mParameters.mOperation);
            long waitMs = this.mContext.getStartMs() - CommonUtils.getCurrentMs();
            if (waitMs < 0L) {
                throw new IllegalStateException(String.format("Thread missed barrier. Increase the start delay. start: %d current: %d", this.mContext.getStartMs(), CommonUtils.getCurrentMs()));
            }
            CommonUtils.sleepMs((long)waitMs);
            StressClientIOBench.this.mStartBarrierPassed = true;
            while (!(Thread.currentThread().isInterrupted() || isRead && CommonUtils.getCurrentMs() >= this.mContext.getEndMs())) {
                int ioBytes = this.applyOperation();
                long currentMs = CommonUtils.getCurrentMs();
                if (currentMs <= recordMs) continue;
                if (ioBytes > 0) {
                    this.mThreadCountResult.incrementIOBytes((long)ioBytes);
                }
                if (((StressClientIOBench)StressClientIOBench.this).mParameters.mOperation != ClientIOOperation.WRITE || ioBytes >= 0) continue;
                break;
            }
        }

        protected abstract int applyOperation() throws IOException, AlluxioException;

        protected abstract void closeInStream();
    }

    private final class BenchContext {
        private final long mStartMs;
        private final long mEndMs;
        private ClientIOTaskResult.ThreadCountResult mThreadCountResult;

        public BenchContext(long startMs, long endMs) {
            this.mStartMs = startMs;
            this.mEndMs = endMs;
        }

        public long getStartMs() {
            return this.mStartMs;
        }

        public long getEndMs() {
            return this.mEndMs;
        }

        public synchronized void mergeThreadResult(ClientIOTaskResult.ThreadCountResult threadResult) {
            if (this.mThreadCountResult == null) {
                this.mThreadCountResult = threadResult;
            } else {
                try {
                    this.mThreadCountResult.merge(threadResult);
                }
                catch (Exception e) {
                    this.mThreadCountResult.addErrorMessage(e.getMessage());
                }
            }
        }

        public synchronized ClientIOTaskResult.ThreadCountResult getResult() {
            return this.mThreadCountResult;
        }
    }
}

