/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli.suite;

import alluxio.ClientContext;
import alluxio.client.job.JobMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.stress.Parameters;
import alluxio.stress.TaskResult;
import alluxio.stress.cli.Benchmark;
import alluxio.stress.common.AbstractMaxThroughputSummary;
import alluxio.stress.common.GeneralBenchSummary;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.worker.job.JobMasterClientContext;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParametersDelegate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMaxThroughput<Q extends TaskResult, T extends AbstractMaxThroughputSummary<P, S>, S extends GeneralBenchSummary<Q>, P extends Parameters>
extends Benchmark<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractMaxThroughput.class);
    @ParametersDelegate
    protected P mParameters;
    protected T mMaxThroughputResult;
    protected int mInitialThroughput = -1;

    public abstract void initParameters(List<String> var1);

    protected abstract S runSingleTest(List<String> var1, int var2) throws Exception;

    @Override
    public String run(String[] args) throws Exception {
        ArrayList baseArgs = Lists.newArrayList();
        baseArgs.addAll(Arrays.asList(args));
        this.initParameters(baseArgs);
        JCommander jc = new JCommander((Object)this);
        jc.setProgramName(this.getClass().getSimpleName());
        try {
            jc.parse(baseArgs.toArray(new String[0]));
            if (this.mBaseParameters.mHelp) {
                System.out.println(this.getBenchDescription());
                jc.usage();
                System.exit(0);
            }
        }
        catch (Exception e) {
            System.out.println(this.getBenchDescription());
            jc.usage();
            throw e;
        }
        this.prepare();
        T result = this.computeMaxThroughput(baseArgs);
        return result.toJson();
    }

    private T computeMaxThroughput(List<String> baseArgs) throws Exception {
        int current;
        int numWorkers = 0;
        try (JobMasterClient client = JobMasterClient.Factory.create((JobMasterClientContext)JobMasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)new InstancedConfiguration(ConfigurationUtils.defaults()))).build());){
            numWorkers = client.getAllWorkerHealth().size();
        }
        if (numWorkers <= 0) {
            throw new IllegalStateException("No workers available for testing!");
        }
        int lower = 0;
        int upper = Integer.MAX_VALUE;
        int next = this.mInitialThroughput;
        int best = 0;
        do {
            int perWorkerThroughput = next / numWorkers;
            int requestedThroughput = perWorkerThroughput * numWorkers;
            if (perWorkerThroughput == 0) break;
            ArrayList<String> newArgs = new ArrayList<String>(baseArgs);
            this.updateArgValue(newArgs, "--target-throughput", Integer.toString(perWorkerThroughput));
            S mbr = this.runSingleTest(newArgs, perWorkerThroughput);
            current = next;
            float actualThroughput = mbr.getThroughput();
            if (actualThroughput > (float)requestedThroughput || (double)(((float)requestedThroughput - actualThroughput) / (float)requestedThroughput) < 0.02) {
                this.mMaxThroughputResult.addPassedRun((long)current, mbr);
                best = current;
                lower = current;
                next = upper == Integer.MAX_VALUE ? (next *= 2) : (next + upper) / 2;
            } else {
                this.mMaxThroughputResult.addFailedRun((long)current, mbr);
                upper = current;
                next = (lower + next) / 2;
            }
            LOG.info("target: " + requestedThroughput + " actual: " + actualThroughput + " [" + lower + " " + next + " " + upper + "]");
            for (String error : mbr.collectErrorsFromAllNodes()) {
                LOG.error("{}", (Object)error);
            }
        } while (!((double)((float)Math.abs(current - next) / (float)current) <= 0.02));
        this.mMaxThroughputResult.setEndTimeMs(CommonUtils.getCurrentMs());
        this.mMaxThroughputResult.setMaxThroughput((float)best);
        return this.mMaxThroughputResult;
    }

    protected void updateArgValue(List<String> args, String argName, String argValue) {
        int index = args.indexOf(argName);
        if (index == -1) {
            args.add(argName);
            args.add(argValue);
            return;
        }
        if (index + 1 < args.size()) {
            args.set(index + 1, argValue);
        }
    }

    @Override
    public T runLocal() {
        throw new UnsupportedOperationException("Not supported operation when running maxThrough test.");
    }
}

