/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli;

import alluxio.stress.BaseParameters;
import alluxio.stress.cli.BatchTask;
import alluxio.stress.cli.StressMasterBench;
import alluxio.stress.master.MasterBatchTaskParameters;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParametersDelegate;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterBatchTask
extends BatchTask {
    private static final Logger LOG = LoggerFactory.getLogger(MasterBatchTask.class);
    private static final int TARGET_THROUGHPUT = 1000000;
    @ParametersDelegate
    private final BaseParameters mBaseParameter = new BaseParameters();
    @ParametersDelegate
    private final MasterBatchTaskParameters mParameter = new MasterBatchTaskParameters();

    @Override
    public void run(String[] args) {
        JCommander jc = new JCommander((Object)this);
        jc.setProgramName(this.getClass().getSimpleName());
        try {
            jc.parse(args);
        }
        catch (Exception e) {
            LOG.error("Failed to parse command: ", (Throwable)e);
            System.out.println(this.getDescription());
            throw e;
        }
        if (this.mParameter.mWriteType.equals("ALL")) {
            System.err.format("Parameter write-type ALL is not supported in batch task %s", this.mParameter.mTaskName);
            return;
        }
        if (this.mParameter.mStopCount != -1 && !this.mParameter.mWarmup.equals("0") && !this.mParameter.mWarmup.equals("0s")) {
            System.out.println("Warning: when using stop-count parameter to claim the files to be operated, the operations executed in warmup time will not be calculated inthe final result. The calculated operations will be less than expected.");
        }
        List<String[]> command = this.getCommand();
        for (String[] arg : command) {
            System.out.println("-----------------------------------------------------");
            System.out.format("Now executing command : %s on MasterStressBench...%n", arg[1]);
            try {
                StressMasterBench bench = new StressMasterBench();
                String jsonResult = bench.run(arg);
                System.out.println("Task finished successfully. The result is following :");
                System.out.println(jsonResult);
            }
            catch (Exception e) {
                System.err.format("Failed to finish the %s operation%n", arg[1]);
                e.printStackTrace();
            }
        }
        System.out.println("-----------------------------------------------------");
        System.out.println("All tasks finished. You can find the test results in the outputs above.");
    }

    private List<String[]> getCommand() {
        ArrayList<String[]> commandList = new ArrayList<String[]>();
        if (this.mParameter.mTaskName.equals("MasterComprehensiveFileBatchTask")) {
            String[] operations;
            for (String op : operations = new String[]{"CreateFile", "ListDir", "ListDirLocated", "GetBlockLocations", "GetFileStatus", "OpenFile", "DeleteFile"}) {
                ArrayList<String> command = new ArrayList<String>(Arrays.asList("--operation", op, "--base", this.mParameter.mBasePath, "--threads", String.valueOf(this.mParameter.mThreads), "--stop-count", String.valueOf(this.mParameter.mStopCount), "--target-throughput", String.valueOf(1000000), "--warmup", this.mParameter.mWarmup, "--create-file-size", this.mParameter.mCreateFileSize, "--write-type", this.mParameter.mWriteType, "--clients", String.valueOf(this.mParameter.mClients), "--client-type", this.mParameter.mClientType.toString(), "--read-type", this.mParameter.mReadType.toString(), "--fixed-count", String.valueOf(this.mParameter.mStopCount)));
                command.addAll(this.mBaseParameter.toBatchTaskArgumentString());
                commandList.add(command.toArray(new String[0]));
            }
        }
        return commandList;
    }

    private String getDescription() {
        return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"BatchTaskRunner is a tool to execute pre-defined group of MasterStressBench tasks", (Object)"", (Object)"Example:", (Object)"# this would run `CreateFile', 'ListDir', 'ListDirLocated', 'GetBlockLocations', 'GetFileStatus', 'OpenFile', 'DeleteFile' operations for 1000 files with size 1KB in 10 threads and record the throughput. The file will be created in directory alluxio:///stress-master-base", (Object)"$ bin/alluxio runClass alluxio.stress.cli.BatchTaskRunner MasterComprehensiveFileBatchTask --num-files 1000 --threads 10 --create-file-size 1k --base alluxio:///stress-master-base --warmup 0s", (Object)""));
    }
}

