/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli.client;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.policy.BlockLocationPolicy;
import alluxio.client.block.policy.options.GetWorkerOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.wire.WorkerNetAddress;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ClientIOWritePolicy
implements BlockLocationPolicy {
    private static final AtomicInteger MAX_WORKERS = new AtomicInteger(1);
    private List<BlockWorkerInfo> mWorkerInfoList;
    private int mIndex;
    private volatile boolean mInitialized = false;

    public static void setMaxWorkers(int maxWorkers) {
        MAX_WORKERS.set(maxWorkers);
    }

    public ClientIOWritePolicy(AlluxioConfiguration ignoredConf) {
    }

    public Optional<WorkerNetAddress> getWorker(GetWorkerOptions options) {
        HashMap<WorkerNetAddress, BlockWorkerInfo> eligibleWorkers = new HashMap<WorkerNetAddress, BlockWorkerInfo>();
        for (BlockWorkerInfo info : options.getBlockWorkerInfos()) {
            eligibleWorkers.put(info.getNetAddress(), info);
        }
        if (!this.mInitialized) {
            this.mWorkerInfoList = Lists.newArrayList((Iterable)options.getBlockWorkerInfos());
            this.mWorkerInfoList.sort(Comparator.comparing(w -> w.getNetAddress().getHost()));
            this.mWorkerInfoList = this.mWorkerInfoList.subList(0, Math.min(MAX_WORKERS.get(), this.mWorkerInfoList.size()));
            if (this.mWorkerInfoList.size() < MAX_WORKERS.get()) {
                throw new IllegalStateException(String.format("Not enough eligible workers. expected: %d actual: %d", MAX_WORKERS.get(), this.mWorkerInfoList.size()));
            }
            this.mIndex = 0;
            this.mInitialized = true;
        }
        for (int i = 0; i < this.mWorkerInfoList.size(); ++i) {
            WorkerNetAddress candidate = this.mWorkerInfoList.get(this.mIndex).getNetAddress();
            this.mIndex = (this.mIndex + 1) % this.mWorkerInfoList.size();
            BlockWorkerInfo workerInfo = (BlockWorkerInfo)eligibleWorkers.get(candidate);
            if (workerInfo == null || workerInfo.getCapacityBytes() < options.getBlockInfo().getLength()) continue;
            return Optional.of(candidate);
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientIOWritePolicy)) {
            return false;
        }
        ClientIOWritePolicy that = (ClientIOWritePolicy)o;
        return Objects.equal(this.mWorkerInfoList, that.mWorkerInfoList) && Objects.equal((Object)this.mIndex, (Object)that.mIndex) && Objects.equal((Object)this.mInitialized, (Object)that.mInitialized);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mWorkerInfoList, this.mIndex, this.mInitialized});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("workerInfoList", this.mWorkerInfoList).add("index", this.mIndex).add("initialized", this.mInitialized).toString();
    }
}

