/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli.suite;

import alluxio.ClientContext;
import alluxio.client.job.JobMasterClient;
import alluxio.job.util.SerializationUtils;
import alluxio.stress.cli.Benchmark;
import alluxio.stress.cli.StressMasterBench;
import alluxio.stress.cli.suite.AbstractMaxThroughput;
import alluxio.stress.common.GeneralBenchSummary;
import alluxio.stress.master.MasterBenchParameters;
import alluxio.stress.master.MasterBenchSummary;
import alluxio.stress.master.MasterBenchTaskResult;
import alluxio.stress.master.MasterMaxThroughputSummary;
import alluxio.stress.master.Operation;
import alluxio.util.FormatUtils;
import alluxio.util.JsonSerializable;
import alluxio.worker.job.JobMasterClientContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterMaxThroughput
extends AbstractMaxThroughput<MasterBenchTaskResult, MasterMaxThroughputSummary, GeneralBenchSummary<MasterBenchTaskResult>, MasterBenchParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(MasterMaxThroughput.class);
    private int mNumWorkers = 0;
    private final List<String> mBaseArgs = Lists.newArrayList();

    public static void main(String[] args) {
        MasterMaxThroughput.mainInternal(args, new MasterMaxThroughput());
    }

    private MasterMaxThroughput() {
    }

    @Override
    public void initParameters(List<String> baseArgs) {
        this.mParameters = new MasterBenchParameters();
        this.mBaseArgs.addAll(baseArgs);
    }

    @Override
    public void prepare() throws Exception {
        this.mMaxThroughputResult = new MasterMaxThroughputSummary();
        ((MasterMaxThroughputSummary)this.mMaxThroughputResult).setParameters(this.mParameters);
        this.mInitialThroughput = ((MasterBenchParameters)this.mParameters).mTargetThroughput;
        if (!((MasterBenchParameters)this.mParameters).mSkipPrepare) {
            this.prepareBeforeAllTests(this.mBaseArgs);
        }
        try (JobMasterClient client = JobMasterClient.Factory.create((JobMasterClientContext)JobMasterClientContext.newBuilder((ClientContext)ClientContext.create()).build());){
            this.mNumWorkers = client.getAllWorkerHealth().size();
        }
    }

    @Override
    protected MasterBenchSummary runSingleTest(List<String> args, int targetThroughput) throws Exception {
        long runSec = (FormatUtils.parseTimeSize((String)((MasterBenchParameters)this.mParameters).mDuration) + FormatUtils.parseTimeSize((String)((MasterBenchParameters)this.mParameters).mWarmup)) / 1000L;
        long requiredCount = (long)targetThroughput * runSec;
        this.prepareBeforeSingleTest(requiredCount, args);
        StressMasterBench b = new StressMasterBench();
        String result = ((Benchmark)b).run(args.toArray(new String[0]));
        return (MasterBenchSummary)JsonSerializable.fromJson((String)SerializationUtils.parseBenchmarkResult((String)result), (JsonSerializable[])new MasterBenchSummary[0]);
    }

    @Override
    public String getBenchDescription() {
        return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"", (Object)"A benchmarking tool to measure the master max throughput of Alluxio.", (Object)"Example:", (Object)"# this would continuously run `ListDir` opeartion and record the throughput after 5s warmup.", (Object)"$ bin/alluxio runClass alluxio.stress.cli.suite.MasterMaxThroughput \\", (Object)"--operation ListDir --warmup 5s", (Object)""));
    }

    private void createFiles(long numFiles, List<String> args) throws Exception {
        ArrayList<String> newArgs = new ArrayList<String>(args);
        this.updateArgValue(newArgs, "--operation", Operation.CREATE_FILE.toString());
        this.updateArgValue(newArgs, "--warmup", "0s");
        this.updateArgValue(newArgs, "--threads", "128");
        this.updateArgValue(newArgs, "--stop-count", Long.toString(numFiles));
        this.updateArgValue(newArgs, "--target-throughput", "10000");
        LOG.info(String.format("Preparing %d files. args: %s", numFiles, String.join((CharSequence)" ", newArgs)));
        StressMasterBench b = new StressMasterBench();
        String result = ((Benchmark)b).run(newArgs.toArray(new String[0]));
        MasterBenchSummary summary = (MasterBenchSummary)JsonSerializable.fromJson((String)SerializationUtils.parseBenchmarkResult((String)result), (JsonSerializable[])new MasterBenchSummary[0]);
        if (!summary.collectErrorsFromAllNodes().isEmpty()) {
            throw new IllegalStateException(String.format("Could not create files for operation (%s). error: %s", ((MasterBenchParameters)this.mParameters).mOperation, summary.collectErrorsFromAllNodes().iterator().next()));
        }
    }

    private void prepareBeforeAllTests(List<String> args) throws Exception {
        switch (((MasterBenchParameters)this.mParameters).mOperation) {
            case GET_BLOCK_LOCATIONS: 
            case GET_FILE_STATUS: 
            case LIST_DIR: 
            case LIST_DIR_LOCATED: 
            case OPEN_FILE: {
                this.createFiles(((MasterBenchParameters)this.mParameters).mFixedCount, args);
                break;
            }
        }
    }

    private void prepareBeforeSingleTest(long requiredCount, List<String> args) throws Exception {
        switch (((MasterBenchParameters)this.mParameters).mOperation) {
            case RENAME_FILE: 
            case DELETE_FILE: {
                float perWorkerCount = (float)requiredCount / (float)this.mNumWorkers * 1.5f;
                this.createFiles(Math.max((long)perWorkerCount, (long)((MasterBenchParameters)this.mParameters).mFixedCount), args);
                break;
            }
        }
    }
}

