/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.table;

import alluxio.client.file.FileSystem;
import alluxio.collections.Pair;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.status.NotFoundException;
import alluxio.grpc.table.ColumnStatisticsInfo;
import alluxio.grpc.table.ColumnStatisticsList;
import alluxio.grpc.table.Constraint;
import alluxio.grpc.table.Database;
import alluxio.grpc.table.SyncStatus;
import alluxio.master.journal.JournalContext;
import alluxio.master.journal.JournalEntryIterable;
import alluxio.master.journal.Journaled;
import alluxio.master.journal.checkpoint.CheckpointName;
import alluxio.master.table.CatalogContext;
import alluxio.master.table.Database;
import alluxio.master.table.DatabaseInfo;
import alluxio.master.table.Partition;
import alluxio.master.table.Table;
import alluxio.proto.journal.Journal;
import alluxio.proto.journal.Table;
import alluxio.resource.CloseableIterator;
import alluxio.resource.LockResource;
import alluxio.table.common.Layout;
import alluxio.table.common.LayoutRegistry;
import alluxio.table.common.transform.TransformDefinition;
import alluxio.table.common.transform.TransformPlan;
import alluxio.table.common.udb.UdbContext;
import alluxio.table.common.udb.UnderDatabaseRegistry;
import alluxio.util.StreamUtils;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlluxioCatalog
implements Journaled {
    private static final Logger LOG = LoggerFactory.getLogger(AlluxioCatalog.class);
    private final Map<String, Database> mDBs = new ConcurrentHashMap<String, Database>();
    private final Map<String, ReentrantLock> mDbLocks = new ConcurrentHashMap<String, ReentrantLock>();
    private final UnderDatabaseRegistry mUdbRegistry;
    private final LayoutRegistry mLayoutRegistry;
    private final FileSystem mFileSystem = FileSystem.Factory.create();

    public AlluxioCatalog() {
        this.mUdbRegistry = new UnderDatabaseRegistry();
        this.mUdbRegistry.refresh();
        this.mLayoutRegistry = new LayoutRegistry();
        this.mLayoutRegistry.refresh();
    }

    private LockResource getDbLock(String dbName) {
        ReentrantLock lock = this.mDbLocks.compute(dbName, (key, value) -> value == null ? new ReentrantLock() : value);
        return new LockResource((Lock)lock);
    }

    public LayoutRegistry getLayoutRegistry() {
        return this.mLayoutRegistry;
    }

    /*
     * Loose catch block
     */
    public SyncStatus attachDatabase(JournalContext journalContext, String udbType, String udbConnectionUri, String udbDbName, String dbName, Map<String, String> map, boolean ignoreSyncErrors) throws IOException {
        try (LockResource l = this.getDbLock(dbName);){
            if (this.mDBs.containsKey(dbName)) {
                throw new IOException(String.format("Unable to attach database. Database name %s (type: %s) already exists.", dbName, udbType));
            }
            this.applyAndJournal((Supplier)journalContext, Journal.JournalEntry.newBuilder().setAttachDb(Table.AttachDbEntry.newBuilder().setUdbType(udbType).setUdbConnectionUri(udbConnectionUri).setUdbDbName(udbDbName).setDbName(dbName).putAllConfig(map).build()).build());
            boolean syncError = false;
            try {
                SyncStatus status = this.mDBs.get(dbName).sync(journalContext);
                syncError = status.getTablesErrorsCount() > 0;
                SyncStatus syncStatus = status;
                return syncStatus;
            }
            catch (Exception e) {
                syncError = true;
                LOG.error(String.format("Sync (during attach) failed for db '%s'.", dbName), (Throwable)e);
                throw new IOException(String.format("Failed to connect underDb for Alluxio db '%s': %s", dbName, e.getMessage()), e);
            }
            finally {
                if (syncError && !ignoreSyncErrors) {
                    this.applyAndJournal((Supplier)journalContext, Journal.JournalEntry.newBuilder().setDetachDb(Table.DetachDbEntry.newBuilder().setDbName(dbName).build()).build());
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public SyncStatus syncDatabase(JournalContext journalContext, String dbName) throws IOException {
        SyncStatus syncStatus;
        block8: {
            LockResource l = this.getDbLock(dbName);
            try {
                Database db = this.getDatabaseByName(dbName);
                syncStatus = db.sync(journalContext);
                if (l == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (l != null) {
                        try {
                            l.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error(String.format("Sync failed for db '%s'.", dbName), (Throwable)e);
                    throw new IOException(String.format("Sync failed for db '%s'. error: %s", dbName, e.getMessage()), e);
                }
            }
            l.close();
        }
        return syncStatus;
    }

    public boolean detachDatabase(JournalContext journalContext, String dbName) throws IOException {
        try (LockResource l = this.getDbLock(dbName);){
            if (!this.mDBs.containsKey(dbName)) {
                throw new IOException(String.format("Unable to detach database. Database name %s does not exist", dbName));
            }
            this.applyAndJournal((Supplier)journalContext, Journal.JournalEntry.newBuilder().setDetachDb(Table.DetachDbEntry.newBuilder().setDbName(dbName).build()).build());
            boolean bl = true;
            return bl;
        }
    }

    public Table getTable(String dbName, String tableName) throws IOException {
        return this.getTableInternal(dbName, tableName);
    }

    private Table getTableInternal(String dbName, String tableName) throws IOException {
        Database db = this.getDatabaseByName(dbName);
        return db.getTable(tableName);
    }

    public List<String> getAllDatabases() throws IOException {
        return new ArrayList<String>(this.mDBs.keySet());
    }

    public alluxio.grpc.table.Database getDatabase(String dbName) throws IOException {
        Database db = this.getDatabaseByName(dbName);
        DatabaseInfo dbInfo = db.getDatabaseInfo();
        Database.Builder builder = alluxio.grpc.table.Database.newBuilder().setDbName(db.getName()).putAllParameter(dbInfo.getParameters());
        if (dbInfo.getComment() != null) {
            builder.setComment(dbInfo.getComment());
        }
        if (dbInfo.getLocation() != null) {
            builder.setLocation(dbInfo.getLocation());
        }
        if (dbInfo.getOwnerName() != null) {
            builder.setOwnerName(dbInfo.getOwnerName());
        }
        if (dbInfo.getOwnerType() != null) {
            builder.setOwnerType(dbInfo.getOwnerType());
        }
        return builder.build();
    }

    private Database getDatabaseByName(String dbName) throws NotFoundException {
        Database db = this.mDBs.get(dbName);
        if (db == null) {
            throw new NotFoundException(ExceptionMessage.DATABASE_DOES_NOT_EXIST.getMessage(new Object[]{dbName}));
        }
        return db;
    }

    public List<String> getAllTables(String dbName) throws IOException {
        Database db = this.getDatabaseByName(dbName);
        return db.getTables().stream().map(Table::getName).collect(Collectors.toList());
    }

    public List<ColumnStatisticsInfo> getTableColumnStatistics(String dbName, String tableName, List<String> colNames) throws IOException {
        Table table = this.getTableInternal(dbName, tableName);
        return table.getStatistics().stream().filter(info -> colNames.contains(info.getColName())).collect(Collectors.toList());
    }

    public Map<String, ColumnStatisticsList> getPartitionColumnStatistics(String dbName, String tableName, List<String> partNames, List<String> colNames) throws IOException {
        Table table = this.getTableInternal(dbName, tableName);
        List<Partition> partitions = table.getPartitions();
        return partitions.stream().filter(p -> partNames.contains(p.getSpec())).map(p -> new Pair((Object)p.getSpec(), (Object)ColumnStatisticsList.newBuilder().addAllStatistics((Iterable)p.getLayout().getColumnStatsData().entrySet().stream().filter(entry -> colNames.contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList())).build())).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (e1, e2) -> e2));
    }

    public List<alluxio.grpc.table.Partition> readTable(String dbName, String tableName, Constraint constraint) throws IOException {
        Table table = this.getTableInternal(dbName, tableName);
        return table.getPartitions().stream().map(Partition::toProto).collect(Collectors.toList());
    }

    public void completeTransformTable(JournalContext journalContext, String dbName, String tableName, String definition, Map<String, Layout> transformedLayouts) throws IOException {
        try (LockResource l = this.getDbLock(dbName);){
            this.getTableInternal(dbName, tableName);
            Table.CompleteTransformTableEntry entry = Table.CompleteTransformTableEntry.newBuilder().setDbName(dbName).setTableName(tableName).setDefinition(definition).putAllTransformedLayouts(Maps.transformValues(transformedLayouts, Layout::toProto)).build();
            this.applyAndJournal((Supplier)journalContext, Journal.JournalEntry.newBuilder().setCompleteTransformTable(entry).build());
        }
    }

    public List<TransformPlan> getTransformPlan(String dbName, String tableName, TransformDefinition definition) throws IOException {
        return this.getTableInternal(dbName, tableName).getTransformPlans(definition);
    }

    private void apply(Table.AttachDbEntry entry) {
        String udbType = entry.getUdbType();
        String udbConnectionUri = entry.getUdbConnectionUri();
        String udbDbName = entry.getUdbDbName();
        String dbName = entry.getDbName();
        CatalogContext catalogContext = new CatalogContext(this.mUdbRegistry, this.mLayoutRegistry);
        UdbContext udbContext = new UdbContext(this.mUdbRegistry, this.mFileSystem, udbType, udbConnectionUri, udbDbName, dbName);
        Database db = Database.create(catalogContext, udbContext, udbType, dbName, entry.getConfigMap());
        this.mDBs.put(dbName, db);
    }

    private void apply(Table.DetachDbEntry entry) {
        String dbName = entry.getDbName();
        this.mDBs.remove(dbName);
    }

    private void apply(Table.CompleteTransformTableEntry entry) {
        Table table;
        String dbName = entry.getDbName();
        String tableName = entry.getTableName();
        try {
            table = this.getTableInternal(dbName, tableName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry e : entry.getTransformedLayoutsMap().entrySet()) {
            String spec = (String)e.getKey();
            Layout layout = this.mLayoutRegistry.create((alluxio.grpc.table.Layout)e.getValue());
            Partition partition = table.getPartition(spec);
            partition.transform(entry.getDefinition(), layout);
            LOG.debug("Transformed partition {} of table {}.{} to {} with definition {}", new Object[]{spec, dbName, tableName, layout.getLocation(), entry.getDefinition()});
        }
    }

    public boolean processJournalEntry(Journal.JournalEntry entry) {
        if (entry.hasAttachDb()) {
            this.apply(entry.getAttachDb());
            return true;
        }
        if (entry.hasUpdateDatabaseInfo()) {
            Database db = this.mDBs.get(entry.getUpdateDatabaseInfo().getDbName());
            return db.processJournalEntry(entry);
        }
        if (entry.hasAddTable()) {
            Database db = this.mDBs.get(entry.getAddTable().getDbName());
            return db.processJournalEntry(entry);
        }
        if (entry.hasAddTablePartitions()) {
            Database db = this.mDBs.get(entry.getAddTablePartitions().getDbName());
            return db.processJournalEntry(entry);
        }
        if (entry.hasRemoveTable()) {
            Database db = this.mDBs.get(entry.getRemoveTable().getDbName());
            return db.processJournalEntry(entry);
        }
        if (entry.hasDetachDb()) {
            this.apply(entry.getDetachDb());
            return true;
        }
        if (entry.hasCompleteTransformTable()) {
            this.apply(entry.getCompleteTransformTable());
            return true;
        }
        return false;
    }

    public void resetState() {
        this.mDBs.clear();
    }

    private Iterator<Journal.JournalEntry> getDbIterator() {
        final Iterator<Map.Entry<String, Database>> it = this.mDBs.entrySet().iterator();
        return new Iterator<Journal.JournalEntry>(){
            private Map.Entry<String, Database> mEntry = null;

            @Override
            public boolean hasNext() {
                if (this.mEntry != null) {
                    return true;
                }
                if (it.hasNext()) {
                    this.mEntry = (Map.Entry)it.next();
                    return true;
                }
                return false;
            }

            @Override
            public Journal.JournalEntry next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String dbName = this.mEntry.getKey();
                Database database = this.mEntry.getValue();
                UdbContext udbContext = database.getUdb().getUdbContext();
                this.mEntry = null;
                return Journal.JournalEntry.newBuilder().setAttachDb(Table.AttachDbEntry.newBuilder().setUdbType(database.getType()).setUdbConnectionUri(udbContext.getConnectionUri()).setUdbDbName(udbContext.getUdbDbName()).setDbName(dbName).putAllConfig(database.getConfig()).build()).build();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("GetDbIteratorr#Iterator#remove is not supported.");
            }
        };
    }

    public CloseableIterator<Journal.JournalEntry> getJournalEntryIterator() {
        List componentIters = StreamUtils.map(JournalEntryIterable::getJournalEntryIterator, this.mDBs.values());
        return CloseableIterator.concat((CloseableIterator)CloseableIterator.noopCloseable(this.getDbIterator()), (CloseableIterator)CloseableIterator.concat((List)componentIters));
    }

    public CheckpointName getCheckpointName() {
        return CheckpointName.TABLE_MASTER_CATALOG;
    }
}

